"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateUnitOfTime = exports.parsedKillOrSuspendParameter = exports.parsedExecuteTimeout = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parsedKillOrSuspendParameter = parameters => {
  var _parameters$entityId$, _parameters$entityId;
  if (parameters.pid) {
    return {
      pid: Number(parameters.pid[0])
    };
  }
  if (parameters.processName) {
    var _parameters$processNa;
    return {
      process_name: (_parameters$processNa = parameters.processName[0]) !== null && _parameters$processNa !== void 0 ? _parameters$processNa : ''
    };
  }
  return {
    entity_id: (_parameters$entityId$ = parameters === null || parameters === void 0 ? void 0 : (_parameters$entityId = parameters.entityId) === null || _parameters$entityId === void 0 ? void 0 : _parameters$entityId[0]) !== null && _parameters$entityId$ !== void 0 ? _parameters$entityId$ : ''
  };
};
exports.parsedKillOrSuspendParameter = parsedKillOrSuspendParameter;
const UNIT_TO_SECONDS = value => ({
  h: () => value * 60 * 60,
  m: () => value * 60,
  s: () => value
});
const convertToSeconds = (value, unit) => UNIT_TO_SECONDS(value)[unit]();
const EXECUTE_TIMEOUT_REGEX = /^\d+(?=(h|m|s){1}$)/;
const validateUnitOfTime = value => EXECUTE_TIMEOUT_REGEX.test(value);
exports.validateUnitOfTime = validateUnitOfTime;
const parsedExecuteTimeout = timeout => {
  const timeoutMatch = timeout === null || timeout === void 0 ? void 0 : timeout.trim().match(EXECUTE_TIMEOUT_REGEX);
  if (!timeoutMatch) {
    return;
  }
  return convertToSeconds(Number(timeoutMatch[0]), timeoutMatch[1]);
};
exports.parsedExecuteTimeout = parsedExecuteTimeout;