"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetActionDetails = void 0;
var _reactQuery = require("@kbn/react-query");
var _kibana = require("../../../common/lib/kibana");
var _resolve_path_variables = require("../../../common/utils/resolve_path_variables");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetActionDetails = (actionId, options = {}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-action-details', actionId],
    ...options,
    queryFn: () => {
      return http.get((0, _resolve_path_variables.resolvePathVariables)(_constants.ACTION_DETAILS_ROUTE, {
        action_id: actionId.trim() || 'undefined'
      }), {
        version: '2023-10-31'
      });
    }
  });
};
exports.useGetActionDetails = useGetActionDetails;