"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchInsights = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _reactQuery = require("@kbn/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _constants = require("../../../../../../../common/endpoint/constants");
var _kibana = require("../../../../../../common/lib/kibana");
var _translations = require("../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_RETRIES = 5;
const useFetchInsights = ({
  endpointId,
  onSuccess,
  scanCompleted,
  expectedCount,
  expectedTimestamp,
  insightTypes
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const toasts = (0, _kibana.useToasts)();
  const insightTypesSet = new Set(insightTypes);
  return (0, _reactQuery.useQuery)([`fetchInsights-${endpointId}`, expectedCount], async ({
    signal
  }) => {
    if (!expectedCount || !expectedTimestamp) {
      if (expectedCount === 0) {
        onSuccess();
      }
      return [];
    }
    try {
      const result = await http.get(_constants.WORKFLOW_INSIGHTS_ROUTE, {
        version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
        query: {
          targetIds: JSON.stringify([endpointId]),
          size: 100
        },
        signal
      });
      const relevantResults = result.filter(insight => {
        return !(!insightTypesSet.has(insight.type) || (0, _moment.default)(insight.action.timestamp) < expectedTimestamp);
      });
      if (relevantResults.length >= expectedCount) {
        onSuccess();
      }
      return relevantResults;
    } catch (error) {
      if (error.name !== 'AbortError') {
        toasts.addDanger({
          title: _translations.WORKFLOW_INSIGHTS.toasts.fetchInsightsError,
          text: error === null || error === void 0 ? void 0 : error.message
        });
      }
      return [];
    }
  }, {
    refetchOnWindowFocus: false,
    // We need full control over when to refetch
    enabled: !scanCompleted,
    refetchInterval: data => {
      if (!!expectedCount && (data === null || data === void 0 ? void 0 : data.length) !== expectedCount) {
        return 2000;
      }
      return false;
    },
    retry: (failureCount, error) => {
      if (error.name === 'AbortError') {
        return false;
      }
      if (failureCount >= MAX_RETRIES) {
        toasts.addDanger({
          title: _translations.WORKFLOW_INSIGHTS.toasts.maxFetchAttemptsReached,
          text: error === null || error === void 0 ? void 0 : error.message
        });
        return false;
      }
      return true;
    },
    retryDelay: 1000
  });
};
exports.useFetchInsights = useFetchInsights;