"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkAiConnectorsCardComplete = void 0;
var _ai_connectors = require("../../../../../../common/utils/connectors/ai_connectors");
var _authz = require("../../common/connectors/authz");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkAiConnectorsCardComplete = async ({
  http,
  application,
  siemMigrations,
  settings
}) => {
  let isComplete = false;
  const authz = (0, _authz.getConnectorsAuthz)(application.capabilities);
  if (!authz.canReadConnectors) {
    return {
      isComplete,
      metadata: {
        connectors: [],
        ...authz
      }
    };
  }
  const aiConnectors = await (0, _ai_connectors.loadAiConnectors)({
    http,
    settings
  });
  const storedConnectorId = siemMigrations.rules.connectorIdStorage.get();
  if (storedConnectorId) {
    if (aiConnectors.length === 0) {
      siemMigrations.rules.connectorIdStorage.remove();
    } else {
      isComplete = aiConnectors.some(connector => connector.id === storedConnectorId);
    }
  }
  return {
    isComplete,
    metadata: {
      connectors: aiConnectors,
      ...authz
    }
  };
};
exports.checkAiConnectorsCardComplete = checkAiConnectorsCardComplete;