"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statusFilterBaseOptions = void 0;
var _constants = require("../../../../../common/siem_migrations/constants");
var _types = require("../../types");
var _utils = require("../../utils");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusFilterBaseOptions = exports.statusFilterBaseOptions = [{
  label: i18n.INSTALL_FILTER_OPTION,
  data: {
    status: _types.StatusFilterBase.INSTALLED
  }
}, {
  label: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.FULL),
  data: {
    status: _types.StatusFilterBase.TRANSLATED
  }
}, {
  label: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.PARTIAL),
  data: {
    status: _types.StatusFilterBase.PARTIALLY_TRANSLATED
  }
}, {
  label: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.UNTRANSLATABLE),
  data: {
    status: _types.StatusFilterBase.UNTRANSLATABLE
  }
}, {
  label: i18n.FAILED_FILTER_OPTION,
  data: {
    status: _types.StatusFilterBase.FAILED
  }
}];