"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_MIGRATION_SUCCESS = exports.UPDATE_MIGRATION_FAILURE = void 0;
exports.useUpdateSiemMigration = useUpdateSiemMigration;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPDATE_MIGRATION_SUCCESS = exports.UPDATE_MIGRATION_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.updateMigration.success', {
  defaultMessage: 'Migration updated'
});
const UPDATE_MIGRATION_FAILURE = exports.UPDATE_MIGRATION_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.updateMigration.failure', {
  defaultMessage: 'Failed to update migration'
});
function useUpdateSiemMigration(migrationType, {
  onSuccess,
  onError
} = {}) {
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    siemMigrations
  } = (0, _kibana.useKibana)().services;
  const updateMigration = (0, _react.useCallback)(params => {
    if (migrationType === 'rule') {
      return siemMigrations.rules.api.updateMigration(params);
    } else {
      return siemMigrations.dashboards.api.updateDashboardMigration(params);
    }
  }, [siemMigrations, migrationType]);
  return (0, _reactQuery.useMutation)({
    mutationKey: ['siemMigration', migrationType, 'update'],
    mutationFn: async params => {
      return updateMigration(params);
    },
    onSuccess: () => {
      addSuccess(UPDATE_MIGRATION_SUCCESS);
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
    },
    onError: e => {
      addError(e, {
        title: UPDATE_MIGRATION_FAILURE
      });
      onError === null || onError === void 0 ? void 0 : onError(e);
    }
  });
}