"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requiredDashboardMigrationCapabilities = void 0;
var _i18n = require("@kbn/i18n");
var _capabilities = require("../../common/service/capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dashboardCapability = {
  capability: `dashboard_v2.createNew`,
  description: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.service.capabilities.dashboardsAll', {
    defaultMessage: 'Analytics > Dashboards: All'
  })
};
const requiredDashboardMigrationCapabilities = exports.requiredDashboardMigrationCapabilities = {
  minimum: _capabilities.requiredSiemMigrationCapabilities.minimum,
  all: [..._capabilities.requiredSiemMigrationCapabilities.all, dashboardCapability]
};