"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatIntelligencePages = exports.THREAT_INTELLIGENCE_BASE_PATH = void 0;
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Base path for all the pages within the Threat Intelligence plugin.
 */
const THREAT_INTELLIGENCE_BASE_PATH = exports.THREAT_INTELLIGENCE_BASE_PATH = '/threat_intelligence';

/**
 * All the links and navigation properties to be used in the Security Solution plugin.
 */
const threatIntelligencePages = exports.threatIntelligencePages = {
  indicators: {
    oldNavigationName: _translations.INDICATORS,
    newNavigationName: _translations.INTELLIGENCE,
    path: `${THREAT_INTELLIGENCE_BASE_PATH}/indicators`,
    id: 'threat_intelligence',
    description: _translations.DESCRIPTION,
    globalSearchKeywords: [_translations.INTELLIGENCE],
    keywords: [_translations.INTELLIGENCE],
    disabled: false
  }
};