"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LazyAccordion = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/lazy_accordion/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * An accordion that doesn't render it's content unless it's expanded.
 * This component was created because `EuiAccordion`'s eager rendering of
 * accordion content was creating performance issues when used in repeating
 * content on the page.
 *
 * The current implementation actually renders the content *outside* of the
 * actual EuiAccordion when the accordion is expanded! It does this because
 * EuiAccordian applies a `translate` style to the content that causes
 * any draggable content (inside `EuiAccordian`) to have a `translate` style
 * that messes up rendering while the user drags it.
 *
 * TODO: animate the expansion and collapse of content rendered "below"
 * the real `EuiAccordion`.
 */
const LazyAccordion = exports.LazyAccordion = /*#__PURE__*/_react.default.memo(({
  buttonContent,
  buttonContentClassName,
  extraAction,
  forceExpand,
  id,
  onCollapse,
  onExpand,
  paddingSize,
  renderExpandedContent
}) => {
  const [expanded, setExpanded] = (0, _react.useState)(false);
  const onCollapsedClick = (0, _react.useCallback)(() => {
    setExpanded(true);
    if (onExpand != null) {
      onExpand();
    }
  }, [onExpand]);
  const onExpandedClick = (0, _react.useCallback)(() => {
    setExpanded(false);
    if (onCollapse != null) {
      onCollapse();
    }
  }, [onCollapse]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, forceExpand || expanded ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    buttonContent: buttonContent,
    buttonContentClassName: buttonContentClassName,
    "data-test-subj": "lazy-accordion-expanded",
    extraAction: extraAction,
    id: id,
    initialIsOpen: true,
    onClick: onExpandedClick,
    paddingSize: paddingSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)), renderExpandedContent(expanded)) : /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    buttonContent: buttonContent,
    buttonContentClassName: buttonContentClassName,
    "data-test-subj": "lazy-accordion-placeholder",
    extraAction: extraAction,
    id: id,
    onClick: onCollapsedClick,
    paddingSize: paddingSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }));
});
LazyAccordion.displayName = 'LazyAccordion';