"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditTimelineActions = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEditTimelineActions = () => {
  const [actionItem, setActionTimeline] = (0, _react.useState)(null);
  const [isDeleteTimelineModalOpen, setIsDeleteTimelineModalOpen] = (0, _react.useState)(false);
  const [isEnableDownloader, setIsEnableDownloader] = (0, _react.useState)(false);

  // Handle Delete Modal
  const onCloseDeleteTimelineModal = (0, _react.useCallback)(() => {
    setIsDeleteTimelineModalOpen(false);
    setActionTimeline(null);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionItem]);
  const onOpenDeleteTimelineModal = (0, _react.useCallback)(selectedActionItem => {
    setIsDeleteTimelineModalOpen(true);
    if (selectedActionItem != null) {
      setActionTimeline(selectedActionItem);
    }
  }, []);

  // Handle Downloader Modal
  const enableExportTimelineDownloader = (0, _react.useCallback)(selectedActionItem => {
    setIsEnableDownloader(true);
    if (selectedActionItem != null) {
      setActionTimeline(selectedActionItem);
    }
  }, []);
  const disableExportTimelineDownloader = (0, _react.useCallback)(() => {
    setIsEnableDownloader(false);
    setActionTimeline(null);
  }, []);

  // On Compete every tasks
  const onCompleteEditTimelineAction = (0, _react.useCallback)(() => {
    setIsDeleteTimelineModalOpen(false);
    setIsEnableDownloader(false);
    setActionTimeline(null);
  }, []);
  return {
    actionItem,
    onCompleteEditTimelineAction,
    isDeleteTimelineModalOpen,
    onCloseDeleteTimelineModal,
    onOpenDeleteTimelineModal,
    isEnableDownloader,
    enableExportTimelineDownloader,
    disableExportTimelineDownloader
  };
};
exports.useEditTimelineActions = useEditTimelineActions;