"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconHeaderColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common_styles = require("./common_styles");
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _timeline = require("../../../../../common/api/timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/open_timeline/timelines_table/icon_header_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Returns the columns that have icon headers
 */
const getIconHeaderColumns = ({
  timelineType
}) => {
  const columns = {
    note: {
      align: 'center',
      field: 'eventIdToNoteIds',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: i18n.NOTES,
        iconProps: {
          'data-test-subj': 'notes-count-header-icon'
        },
        size: "m",
        type: "editorComment",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 9
        }
      }),
      render: (_, timelineResult) => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "notes-count",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 12
        }
      }, (0, _helpers.getNotesCount)(timelineResult)),
      sortable: false,
      width: _common_styles.ACTION_COLUMN_WIDTH
    },
    pinnedEvent: {
      align: 'center',
      field: 'pinnedEventIds',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: i18n.PINNED_EVENTS,
        iconProps: {
          'data-test-subj': 'pinned-event-header-icon'
        },
        size: "m",
        type: "pin",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 9
        }
      }),
      render: (_, timelineResult) => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "pinned-event-count",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 9
        }
      }, `${(0, _helpers.getPinnedEventCount)(timelineResult)}`),
      sortable: false,
      width: _common_styles.ACTION_COLUMN_WIDTH
    },
    favorite: {
      align: 'center',
      field: 'favorite',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: i18n.FAVORITES,
        iconProps: {
          'data-test-subj': 'favorites-header-icon'
        },
        size: "m",
        type: "starEmpty",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 9
        }
      }),
      render: favorite => {
        const isFavorite = favorite != null && favorite.length > 0;
        const fill = isFavorite ? 'starFilled' : 'starEmpty';
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          "data-test-subj": `favorite-${fill}-star`,
          type: fill,
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 16
          }
        });
      },
      sortable: false,
      width: _common_styles.ACTION_COLUMN_WIDTH
    }
  };
  const templateColumns = [columns.note, columns.favorite];
  const defaultColumns = [columns.pinnedEvent, columns.note, columns.favorite];
  return timelineType === _timeline.TimelineTypeEnum.template ? templateColumns : defaultColumns;
};
exports.getIconHeaderColumns = getIconHeaderColumns;