"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SESSION = exports.SENT_TO = exports.SENT_TEST = exports.SENT_MESSAGE = exports.SCHEDULED_POLICY_OF = exports.ROTATED_AUDIT_LOGS = exports.RESUMED_AUDIT_LOGGING = exports.RENAMED = exports.REMOVED_USER_ROLE_FROM = exports.REMOTE_AUDIT_DISCONNECTED = exports.REMOTE_AUDIT_CONNECTED = exports.RELABELED_FILESYSTEM = exports.REFRESHED_CREDENTIALS_FOR = exports.RECONFIGURED_AUDIT = exports.RECEIVED_FROM = exports.RAN_COMMAND = exports.OVERRODE_LABEL_OF = exports.OPENED_TOO_MANY_SESSIONS = exports.OPENED_FILE = exports.NEGOTIATED_CRYPTO_KEY = exports.MOUNTED = exports.MODIFIED_USER_ACCOUNT = exports.MODIFIED_ROLE = exports.MODIFIED_LEVEL_OF = exports.MODIFIED_GROUP_ACCOUNT = exports.MIGRATED_VM_TO = exports.MIGRATED_VM_FROM = exports.MADE_DEVICE_WITH = exports.MAC_PERMISSION = exports.LOGGED_OUT = exports.LOCKED_ACCOUNT = exports.LOADED_SELINUX_POLICY = exports.LOADED_MAC_POLICY = exports.LOADED_KERNEL_MODULE = exports.LOADED_FIREWALL_RULE = exports.LISTEN_FOR_CONNECTIONS = exports.KILLED_PROCESS_ID_OF = exports.ISSUED_VM_CONTROL = exports.INITIALIZED_AUDIT_SUBSYSTEM = exports.FAILED_LOGIN_TOO_MANY_TIMES = exports.EXECUTION_OF_FORBIDDEN_PROGRAM = exports.EXECUTED = exports.ERROR_FROM = exports.ENDED_FROM = exports.DISPOSED_CREDENTIALS_TO = exports.DELETED_VM_IMAGE = exports.DELETED_USER_ACCOUNT_USING = exports.DELETED_GROUP_ACCOUNT_USING = exports.DELETED = exports.CRYPTO_OFFICER_LOGGED_OUT = exports.CRYPTO_OFFICER_LOGGED_IN = exports.CREATED_VM_IMAGE = exports.CREATED_DIRECTORY = exports.CRASHED_PROGRAM = exports.CONNECTED_USING = exports.CHECKED_METADATA_OF = exports.CHECKED_INTEGRITY_OF = exports.CHECKED_FILE_SYSTEM_METADATA_OF = exports.CHANGED_USER_ID = exports.CHANGED_TO_RUN_LEVEL_WITH = exports.CHANGED_TIME_STAMP_OF = exports.CHANGED_SYSTEM_TIME_WITH = exports.CHANGED_SYSTEM_NAME = exports.CHANGED_SELINUX_ENFORCEMENT = exports.CHANGED_SELINUX_BOOLEAN = exports.CHANGED_ROLE_USING = exports.CHANGED_PROMISCUOUS_MODE = exports.CHANGED_PASSWORD_WITH = exports.CHANGED_MAC_CONFIGURATION = exports.CHANGED_LOGIN_ID_TO = exports.CHANGED_IDENTITY_USING = exports.CHANGED_GROUP_PASSWORD = exports.CHANGED_GROUP = exports.CHANGED_FILE_PERMISSIONS_OF = exports.CHANGED_FILE_OWNERSHIP_OF = exports.CHANGED_FILE_ATTRIBUTES_OF = exports.CHANGED_CONFIGURATION_WITH = exports.CHANGED_AUDIT_FEATURE = exports.CHANGED_AUDIT_CONFIGURATION = exports.CAUSED_MAC_POLICY_ERROR = exports.BOUND_SOCKET_FROM = exports.BOOTED_SYSTEM = exports.AUTHENTICATED_USING = exports.AUTHENTICATED_TO_GROUP = exports.AUDIT_ERROR = exports.ATTEMPTED_LOGIN_FROM_UNUSUAL_PLACE = exports.ATTEMPTED_LOGIN_FROM_UNUSUAL_HOUR = exports.ATTEMPTED_LOGIN = exports.ASSIGNED_VM_RESOURCE = exports.ASSIGNED_VM_ID = exports.ASSIGNED_USER_ROLE_TO = exports.AS = exports.ALLOCATED_MEMORY_FOR = exports.ADDED_USER_ACCOUNT = exports.ADDED_GROUP_ACCOUNT_USING = exports.ACQUIRED_CREDENTIALS_TO = exports.ACCESS_RESULT = exports.ACCESS_PERMISSION = exports.ACCESS_ERROR = exports.ABORTED_AUDIT_STARTUP = void 0;
exports.WITH_RESULT = exports.WAS_AUTHORIZED_TO_USE = exports.VIOLATED_SELINUX_POLICY = exports.VIOLATED_SECCOMP_POLICY_WITH = exports.VIOLATED_APP_ARMOR_POLICY_FROM = exports.USING = exports.USED_SUSPICIOUS_PROGRAM = exports.UNMOUNTED = exports.UNLOCKED_ACCOUNT = exports.UNLOADED_KERNEL_MODULE_OF = exports.UNKNOWN = exports.TESTED_FILE_SYSTEM_INTEGRITY = exports.SYMLINKED = exports.STOPPED_SERVICE = exports.STARTED_SERVICE = exports.STARTED_CRYPTO_SESSION = exports.STARTED_AUDIT = exports.STARTED = exports.SHUTDOWN_SYSTEM = exports.SHUTDOWN_AUDIT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Note for translators and programmers
// Examples of these strings are all of the form
// Session {session.id} {primary} as {secondary}@{hostname} in {folder} was authorized to use {executable} with result {result.success/failure}
// E.x. Session 5 Frank as root@server-1 in /root was authorized to use wget with result success

// However, the strings can be dropped depending on the circumstances of the variables. For example, with no data at all
// Session 10
// Example with just a user name and hostname
// Session 20 frank@server-1
// Example with user name, hostname, but no result
// Session 20 frank@server-1 acquired credentials to curl

const SESSION = exports.SESSION = _i18n.i18n.translate('xpack.securitySolution.auditd.sessionDescription', {
  defaultMessage: 'Session'
});
const WAS_AUTHORIZED_TO_USE = exports.WAS_AUTHORIZED_TO_USE = _i18n.i18n.translate('xpack.securitySolution.auditd.wasAuthorizedToUseDescription', {
  defaultMessage: 'was authorized to use'
});
const ACQUIRED_CREDENTIALS_TO = exports.ACQUIRED_CREDENTIALS_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.acquiredCredentialsDescription', {
  defaultMessage: 'acquired credentials to'
});
const ENDED_FROM = exports.ENDED_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.endedFromDescription', {
  defaultMessage: 'ended from'
});
const STARTED = exports.STARTED = _i18n.i18n.translate('xpack.securitySolution.auditd.startedAtDescription', {
  defaultMessage: 'started'
});
const DISPOSED_CREDENTIALS_TO = exports.DISPOSED_CREDENTIALS_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.disposedCredentialsDescription', {
  defaultMessage: 'disposed credentials to'
});
const ATTEMPTED_LOGIN = exports.ATTEMPTED_LOGIN = _i18n.i18n.translate('xpack.securitySolution.auditd.attemptedLoginDescription', {
  defaultMessage: 'attempted a login via'
});
const WITH_RESULT = exports.WITH_RESULT = _i18n.i18n.translate('xpack.securitySolution.auditd.withResultDescription', {
  defaultMessage: 'with result'
});
const EXECUTED = exports.EXECUTED = _i18n.i18n.translate('xpack.securitySolution.auditd.executedDescription', {
  defaultMessage: 'executed'
});
const AS = exports.AS = _i18n.i18n.translate('xpack.securitySolution.auditd.asDescription', {
  defaultMessage: 'as'
});
const CONNECTED_USING = exports.CONNECTED_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.connectedUsingDescription', {
  defaultMessage: 'connected using'
});
const USING = exports.USING = _i18n.i18n.translate('xpack.securitySolution.auditd.usingDescription', {
  defaultMessage: 'using'
});
const OPENED_FILE = exports.OPENED_FILE = _i18n.i18n.translate('xpack.securitySolution.auditd.OpenedFileDescription', {
  defaultMessage: 'opened file'
});
const CHANGED_FILE_ATTRIBUTES_OF = exports.CHANGED_FILE_ATTRIBUTES_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.ChangedFileAttributesOfDescription', {
  defaultMessage: 'changed file attributes of'
});
const CHANGED_FILE_PERMISSIONS_OF = exports.CHANGED_FILE_PERMISSIONS_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.changedFilePermissionOfDescription', {
  defaultMessage: 'changed file permissions of'
});
const CHANGED_FILE_OWNERSHIP_OF = exports.CHANGED_FILE_OWNERSHIP_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.changeidleOwernshipOfDescription', {
  defaultMessage: 'changed file ownership of'
});
const LOADED_KERNEL_MODULE = exports.LOADED_KERNEL_MODULE = _i18n.i18n.translate('xpack.securitySolution.auditd.loaedKernelModuleOfDescription', {
  defaultMessage: 'loaded kernel module of'
});
const UNLOADED_KERNEL_MODULE_OF = exports.UNLOADED_KERNEL_MODULE_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.unloadedKernelModuleOfDescription', {
  defaultMessage: 'unloaded kernel module of'
});
const CREATED_DIRECTORY = exports.CREATED_DIRECTORY = _i18n.i18n.translate('xpack.securitySolution.auditd.createdDirectoryDescription', {
  defaultMessage: 'created directory'
});
const MOUNTED = exports.MOUNTED = _i18n.i18n.translate('xpack.securitySolution.auditd.mountedDescription', {
  defaultMessage: 'mounted'
});
const RENAMED = exports.RENAMED = _i18n.i18n.translate('xpack.securitySolution.auditd.renamedDescription', {
  defaultMessage: 'renamed'
});
const CHECKED_METADATA_OF = exports.CHECKED_METADATA_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.chedckedMetaDataOfDescription', {
  defaultMessage: 'checked metadata of'
});
const CHECKED_FILE_SYSTEM_METADATA_OF = exports.CHECKED_FILE_SYSTEM_METADATA_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.checkedFileSystemMetadataOfDescription', {
  defaultMessage: 'checked filesystem metadata of'
});
const SYMLINKED = exports.SYMLINKED = _i18n.i18n.translate('xpack.securitySolution.auditd.symLinkedDescription', {
  defaultMessage: 'symbolically linked'
});
const UNMOUNTED = exports.UNMOUNTED = _i18n.i18n.translate('xpack.securitySolution.auditd.unmountedDescription', {
  defaultMessage: 'unmounted'
});
const DELETED = exports.DELETED = _i18n.i18n.translate('xpack.securitySolution.auditd.deletedDescription', {
  defaultMessage: 'deleted'
});
const CHANGED_TIME_STAMP_OF = exports.CHANGED_TIME_STAMP_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.changedTimeStampOfDescription', {
  defaultMessage: 'changed time stamp of'
});
const LISTEN_FOR_CONNECTIONS = exports.LISTEN_FOR_CONNECTIONS = _i18n.i18n.translate('xpack.securitySolution.auditd.ListeningForConnectionsUsingDescription', {
  defaultMessage: 'listening for connections using'
});
const BOUND_SOCKET_FROM = exports.BOUND_SOCKET_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.boundSocketFromDescription', {
  defaultMessage: 'bound socket from'
});
const RECEIVED_FROM = exports.RECEIVED_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.receivedFromDescription', {
  defaultMessage: 'received from'
});
const SENT_TO = exports.SENT_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.sentToDescription', {
  defaultMessage: 'sent to'
});
const KILLED_PROCESS_ID_OF = exports.KILLED_PROCESS_ID_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.killedProcessIdDescription', {
  defaultMessage: 'killed process id of'
});
const CHANGED_IDENTITY_USING = exports.CHANGED_IDENTITY_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.changedIdentityUsingDescription', {
  defaultMessage: 'changed identity using'
});
const CHANGED_SYSTEM_TIME_WITH = exports.CHANGED_SYSTEM_TIME_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.changedSystemTimeWithDescription', {
  defaultMessage: 'changed system time with'
});
const MADE_DEVICE_WITH = exports.MADE_DEVICE_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.madeDeviceWithDescription', {
  defaultMessage: 'made device with'
});
const CHANGED_SYSTEM_NAME = exports.CHANGED_SYSTEM_NAME = _i18n.i18n.translate('xpack.securitySolution.auditd.changedSystemNameDescription', {
  defaultMessage: 'changed system name'
});
const ALLOCATED_MEMORY_FOR = exports.ALLOCATED_MEMORY_FOR = _i18n.i18n.translate('xpack.securitySolution.auditd.allocatedMemoryForDescription', {
  defaultMessage: 'allocated memory for'
});
const SCHEDULED_POLICY_OF = exports.SCHEDULED_POLICY_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.scheduledPolicyOFDescription', {
  defaultMessage: 'scheduled policy of'
});
const ADDED_USER_ACCOUNT = exports.ADDED_USER_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.addedUserAccountDescription', {
  defaultMessage: 'added user account'
});
const CAUSED_MAC_POLICY_ERROR = exports.CAUSED_MAC_POLICY_ERROR = _i18n.i18n.translate('xpack.securitySolution.auditd.causedMacPolicyErrorDescription', {
  defaultMessage: 'caused mac policy error'
});
const LOADED_FIREWALL_RULE = exports.LOADED_FIREWALL_RULE = _i18n.i18n.translate('xpack.securitySolution.auditd.loadedFirewallRuleDescription', {
  defaultMessage: 'loaded firewall rule'
});
const CHANGED_PROMISCUOUS_MODE = exports.CHANGED_PROMISCUOUS_MODE = _i18n.i18n.translate('xpack.securitySolution.auditd.promiscuousModeDescription', {
  defaultMessage: 'changed promiscuous mode on the device using'
});
const LOCKED_ACCOUNT = exports.LOCKED_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.lockedAccountDescription', {
  defaultMessage: 'locked account'
});
const UNLOCKED_ACCOUNT = exports.UNLOCKED_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.unlockedAccountDescription', {
  defaultMessage: 'unlocked account'
});
const ADDED_GROUP_ACCOUNT_USING = exports.ADDED_GROUP_ACCOUNT_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.adddedGroupAccountUsingDescription', {
  defaultMessage: 'added group account using'
});
const CRASHED_PROGRAM = exports.CRASHED_PROGRAM = _i18n.i18n.translate('xpack.securitySolution.auditd.crashedProgramDescription', {
  defaultMessage: 'crashed program'
});
const EXECUTION_OF_FORBIDDEN_PROGRAM = exports.EXECUTION_OF_FORBIDDEN_PROGRAM = _i18n.i18n.translate('xpack.securitySolution.auditd.executionOfForbiddenProgramDescription', {
  defaultMessage: 'execution of forbidden program'
});
const USED_SUSPICIOUS_PROGRAM = exports.USED_SUSPICIOUS_PROGRAM = _i18n.i18n.translate('xpack.securitySolution.auditd.suspiciousProgramDescription', {
  defaultMessage: 'used suspicious program'
});
const FAILED_LOGIN_TOO_MANY_TIMES = exports.FAILED_LOGIN_TOO_MANY_TIMES = _i18n.i18n.translate('xpack.securitySolution.auditd.failedLoginTooManyTimesDescription', {
  defaultMessage: 'failed login due to logging in too many times'
});
const ATTEMPTED_LOGIN_FROM_UNUSUAL_PLACE = exports.ATTEMPTED_LOGIN_FROM_UNUSUAL_PLACE = _i18n.i18n.translate('xpack.securitySolution.auditd.attemptedLoginFromUnusalPlaceDescription', {
  defaultMessage: 'attempted login from unusual place'
});
const OPENED_TOO_MANY_SESSIONS = exports.OPENED_TOO_MANY_SESSIONS = _i18n.i18n.translate('xpack.securitySolution.auditd.openedTooManySessionsDescription', {
  defaultMessage: 'opened too many sessions'
});
const ATTEMPTED_LOGIN_FROM_UNUSUAL_HOUR = exports.ATTEMPTED_LOGIN_FROM_UNUSUAL_HOUR = _i18n.i18n.translate('xpack.securitySolution.auditd.attemptedLoginFromUnusualHourDescription', {
  defaultMessage: 'attempted login from unusual hour'
});
const TESTED_FILE_SYSTEM_INTEGRITY = exports.TESTED_FILE_SYSTEM_INTEGRITY = _i18n.i18n.translate('xpack.securitySolution.auditd.testedFileSystemIntegrityDescription', {
  defaultMessage: 'tested file system integrity'
});
const VIOLATED_SELINUX_POLICY = exports.VIOLATED_SELINUX_POLICY = _i18n.i18n.translate('xpack.securitySolution.auditd.violatedSeLinuxPolicyDescription', {
  defaultMessage: 'violated selinux policy'
});
const VIOLATED_APP_ARMOR_POLICY_FROM = exports.VIOLATED_APP_ARMOR_POLICY_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.violatedAppArmorPolicyFromDescription', {
  defaultMessage: 'violated app armor policy from'
});
const CHANGED_GROUP = exports.CHANGED_GROUP = _i18n.i18n.translate('xpack.securitySolution.auditd.changedGroupDescription', {
  defaultMessage: 'changed group'
});
const CHANGED_USER_ID = exports.CHANGED_USER_ID = _i18n.i18n.translate('xpack.securitySolution.auditd.changedUserIdDescription', {
  defaultMessage: 'changed user id'
});
const CHANGED_AUDIT_CONFIGURATION = exports.CHANGED_AUDIT_CONFIGURATION = _i18n.i18n.translate('xpack.securitySolution.auditd.changedAuditConfigurationDescription', {
  defaultMessage: 'changed audit configuration'
});
const REFRESHED_CREDENTIALS_FOR = exports.REFRESHED_CREDENTIALS_FOR = _i18n.i18n.translate('xpack.securitySolution.auditd.refreshedCredentialsForDescription', {
  defaultMessage: 'refreshed credentials for'
});
const NEGOTIATED_CRYPTO_KEY = exports.NEGOTIATED_CRYPTO_KEY = _i18n.i18n.translate('xpack.securitySolution.auditd.negotiatedCryptoKeyDescription', {
  defaultMessage: 'negotiated crypto key'
});
const CRYPTO_OFFICER_LOGGED_IN = exports.CRYPTO_OFFICER_LOGGED_IN = _i18n.i18n.translate('xpack.securitySolution.auditd.cryptoOfficerLoggedInDescription', {
  defaultMessage: 'crypto officer logged in'
});
const CRYPTO_OFFICER_LOGGED_OUT = exports.CRYPTO_OFFICER_LOGGED_OUT = _i18n.i18n.translate('xpack.securitySolution.auditd.cryptoOfficerLoggedOutDescription', {
  defaultMessage: 'crypto officer logged out'
});
const STARTED_CRYPTO_SESSION = exports.STARTED_CRYPTO_SESSION = _i18n.i18n.translate('xpack.securitySolution.auditd.startedCryptoSessionDescription', {
  defaultMessage: 'started crypto session'
});
const ACCESS_RESULT = exports.ACCESS_RESULT = _i18n.i18n.translate('xpack.securitySolution.auditd.accessResultDescription', {
  defaultMessage: 'access result'
});
const ABORTED_AUDIT_STARTUP = exports.ABORTED_AUDIT_STARTUP = _i18n.i18n.translate('xpack.securitySolution.auditd.abortedAuditStartupDescription', {
  defaultMessage: 'aborted audit startup'
});
const REMOTE_AUDIT_CONNECTED = exports.REMOTE_AUDIT_CONNECTED = _i18n.i18n.translate('xpack.securitySolution.auditd.remoteAuditConnectedDescription', {
  defaultMessage: 'remote audit connected'
});
const REMOTE_AUDIT_DISCONNECTED = exports.REMOTE_AUDIT_DISCONNECTED = _i18n.i18n.translate('xpack.securitySolution.auditd.remoteAuditDisconnectedDescription', {
  defaultMessage: 'remote audit disconnected'
});
const SHUTDOWN_AUDIT = exports.SHUTDOWN_AUDIT = _i18n.i18n.translate('xpack.securitySolution.auditd.shutDownAuditDescription', {
  defaultMessage: 'shutdown audit'
});
const AUDIT_ERROR = exports.AUDIT_ERROR = _i18n.i18n.translate('xpack.securitySolution.auditd.auditErrorDescription', {
  defaultMessage: 'audit error'
});
const RECONFIGURED_AUDIT = exports.RECONFIGURED_AUDIT = _i18n.i18n.translate('xpack.securitySolution.auditd.reconfiguredAuditDescription', {
  defaultMessage: 'reconfigured audit'
});
const RESUMED_AUDIT_LOGGING = exports.RESUMED_AUDIT_LOGGING = _i18n.i18n.translate('xpack.securitySolution.auditd.resumedAuditLoggingDescription', {
  defaultMessage: 'resumed audit logging'
});
const ROTATED_AUDIT_LOGS = exports.ROTATED_AUDIT_LOGS = _i18n.i18n.translate('xpack.securitySolution.auditd.rotatedAuditLogsDescription', {
  defaultMessage: 'rotated-audit-logs'
});
const STARTED_AUDIT = exports.STARTED_AUDIT = _i18n.i18n.translate('xpack.securitySolution.auditd.startedAuditDescription', {
  defaultMessage: 'started audit'
});
const DELETED_GROUP_ACCOUNT_USING = exports.DELETED_GROUP_ACCOUNT_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.deletedGroupAccountUsingDescription', {
  defaultMessage: 'deleted group account using'
});
const DELETED_USER_ACCOUNT_USING = exports.DELETED_USER_ACCOUNT_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.deletedUserAccountUsingDescription', {
  defaultMessage: 'deleted user account using'
});
const CHANGED_AUDIT_FEATURE = exports.CHANGED_AUDIT_FEATURE = _i18n.i18n.translate('xpack.securitySolution.auditd.changedAuditFeatureDescription', {
  defaultMessage: 'changed audit feature'
});
const RELABELED_FILESYSTEM = exports.RELABELED_FILESYSTEM = _i18n.i18n.translate('xpack.securitySolution.auditd.relabeledFileSystemDescription', {
  defaultMessage: 'relabeled filesystem'
});
const AUTHENTICATED_TO_GROUP = exports.AUTHENTICATED_TO_GROUP = _i18n.i18n.translate('xpack.securitySolution.auditd.authenticatedToGroupDescription', {
  defaultMessage: 'authenticated to group'
});
const CHANGED_GROUP_PASSWORD = exports.CHANGED_GROUP_PASSWORD = _i18n.i18n.translate('xpack.securitySolution.auditd.changedGroupPasswordDescription', {
  defaultMessage: 'changed group password'
});
const MODIFIED_GROUP_ACCOUNT = exports.MODIFIED_GROUP_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.modifiedGroupAccountDescription', {
  defaultMessage: 'modified group account'
});
const INITIALIZED_AUDIT_SUBSYSTEM = exports.INITIALIZED_AUDIT_SUBSYSTEM = _i18n.i18n.translate('xpack.securitySolution.auditd.initializedAuditSubsystemDescription', {
  defaultMessage: 'initialized audit subsystem'
});
const MODIFIED_LEVEL_OF = exports.MODIFIED_LEVEL_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.modifiedLevelOfDescription', {
  defaultMessage: 'modified level of'
});
const OVERRODE_LABEL_OF = exports.OVERRODE_LABEL_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.overrodeLabelOfDescription', {
  defaultMessage: 'overrode label of'
});
const CHANGED_LOGIN_ID_TO = exports.CHANGED_LOGIN_ID_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.changedLoginIdToDescription', {
  defaultMessage: 'changed login id to'
});
const MAC_PERMISSION = exports.MAC_PERMISSION = _i18n.i18n.translate('xpack.securitySolution.auditd.macPermissionDescription', {
  defaultMessage: 'mac permission'
});
const CHANGED_SELINUX_BOOLEAN = exports.CHANGED_SELINUX_BOOLEAN = _i18n.i18n.translate('xpack.securitySolution.auditd.changedSeLinuxBooleanDescription', {
  defaultMessage: 'changed selinux boolean'
});
const LOADED_SELINUX_POLICY = exports.LOADED_SELINUX_POLICY = _i18n.i18n.translate('xpack.securitySolution.auditd.loadedSeLinuxPolicyDescription', {
  defaultMessage: 'loaded selinux policy'
});
const CHANGED_SELINUX_ENFORCEMENT = exports.CHANGED_SELINUX_ENFORCEMENT = _i18n.i18n.translate('xpack.securitySolution.auditd.changedSelinuxEnforcementDescription', {
  defaultMessage: 'changed selinux enforcement'
});
const ASSIGNED_USER_ROLE_TO = exports.ASSIGNED_USER_ROLE_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.assignedUserRoleToDescription', {
  defaultMessage: 'assigned user role to'
});
const MODIFIED_ROLE = exports.MODIFIED_ROLE = _i18n.i18n.translate('xpack.securitySolution.auditd.modifiedRoleDescription', {
  defaultMessage: 'modified role'
});
const REMOVED_USER_ROLE_FROM = exports.REMOVED_USER_ROLE_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.removedUserRoleFromDescription', {
  defaultMessage: 'removed user role from'
});
const VIOLATED_SECCOMP_POLICY_WITH = exports.VIOLATED_SECCOMP_POLICY_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.violatedSeccompPolicyWithDescription', {
  defaultMessage: 'violated seccomp policy with'
});
const STARTED_SERVICE = exports.STARTED_SERVICE = _i18n.i18n.translate('xpack.securitySolution.auditd.startedServiceDescription', {
  defaultMessage: 'started service'
});
const STOPPED_SERVICE = exports.STOPPED_SERVICE = _i18n.i18n.translate('xpack.securitySolution.auditd.stoppedServiceDescription', {
  defaultMessage: 'stopped service'
});
const BOOTED_SYSTEM = exports.BOOTED_SYSTEM = _i18n.i18n.translate('xpack.securitySolution.auditd.bootedSystemDescription', {
  defaultMessage: 'booted system'
});
const CHANGED_TO_RUN_LEVEL_WITH = exports.CHANGED_TO_RUN_LEVEL_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.changedToRunLevelWithDescription', {
  defaultMessage: 'changed to run level with'
});
const SHUTDOWN_SYSTEM = exports.SHUTDOWN_SYSTEM = _i18n.i18n.translate('xpack.securitySolution.auditd.shutdownSystemDescription', {
  defaultMessage: 'shutdown system'
});
const SENT_TEST = exports.SENT_TEST = _i18n.i18n.translate('xpack.securitySolution.auditd.sentTestDescription', {
  defaultMessage: 'sent test'
});
const UNKNOWN = exports.UNKNOWN = _i18n.i18n.translate('xpack.securitySolution.auditd.unknownDescription', {
  defaultMessage: 'unknown'
});
const SENT_MESSAGE = exports.SENT_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.auditd.sentMessageDescription', {
  defaultMessage: 'sent message'
});
const ACCESS_PERMISSION = exports.ACCESS_PERMISSION = _i18n.i18n.translate('xpack.securitySolution.auditd.accessPermissionDescription', {
  defaultMessage: 'access permission'
});
const AUTHENTICATED_USING = exports.AUTHENTICATED_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.authenticatedUsingDescription', {
  defaultMessage: 'authenticated using'
});
const CHANGED_PASSWORD_WITH = exports.CHANGED_PASSWORD_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.changedPasswordWithDescription', {
  defaultMessage: 'changed password with'
});
const RAN_COMMAND = exports.RAN_COMMAND = _i18n.i18n.translate('xpack.securitySolution.auditd.ranCommandDescription', {
  defaultMessage: 'ran command'
});
const ERROR_FROM = exports.ERROR_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.errorFromDescription', {
  defaultMessage: 'error from'
});
const LOGGED_OUT = exports.LOGGED_OUT = _i18n.i18n.translate('xpack.securitySolution.auditd.loggedOutDescription', {
  defaultMessage: 'logged out'
});
const CHANGED_MAC_CONFIGURATION = exports.CHANGED_MAC_CONFIGURATION = _i18n.i18n.translate('xpack.securitySolution.auditd.changedMacConfigurationDescription', {
  defaultMessage: 'changed mac configuration'
});
const LOADED_MAC_POLICY = exports.LOADED_MAC_POLICY = _i18n.i18n.translate('xpack.securitySolution.auditd.loadedMacPolicyDescription', {
  defaultMessage: 'loaded mac policy'
});
const MODIFIED_USER_ACCOUNT = exports.MODIFIED_USER_ACCOUNT = _i18n.i18n.translate('xpack.securitySolution.auditd.modifiedUserAccountDescription', {
  defaultMessage: 'modified user account'
});
const CHANGED_ROLE_USING = exports.CHANGED_ROLE_USING = _i18n.i18n.translate('xpack.securitySolution.auditd.changedRoleUsingDescription', {
  defaultMessage: 'changed role using'
});
const ACCESS_ERROR = exports.ACCESS_ERROR = _i18n.i18n.translate('xpack.securitySolution.auditd.accessErrorDescription', {
  defaultMessage: 'access error'
});
const CHANGED_CONFIGURATION_WITH = exports.CHANGED_CONFIGURATION_WITH = _i18n.i18n.translate('xpack.securitySolution.auditd.changedConfigurationWIthDescription', {
  defaultMessage: 'changed configuration with'
});
const ISSUED_VM_CONTROL = exports.ISSUED_VM_CONTROL = _i18n.i18n.translate('xpack.securitySolution.auditd.issuedVmControlDescription', {
  defaultMessage: 'issued vm control'
});
const CREATED_VM_IMAGE = exports.CREATED_VM_IMAGE = _i18n.i18n.translate('xpack.securitySolution.auditd.createdVmImageDescription', {
  defaultMessage: 'created vm image'
});
const DELETED_VM_IMAGE = exports.DELETED_VM_IMAGE = _i18n.i18n.translate('xpack.securitySolution.auditd.deletedVmImageDescription', {
  defaultMessage: 'deleted vm image'
});
const CHECKED_INTEGRITY_OF = exports.CHECKED_INTEGRITY_OF = _i18n.i18n.translate('xpack.securitySolution.auditd.checkedIntegrityOfDescription', {
  defaultMessage: 'checked integrity of'
});
const ASSIGNED_VM_ID = exports.ASSIGNED_VM_ID = _i18n.i18n.translate('xpack.securitySolution.auditd.assignedVmIdDescription', {
  defaultMessage: 'assigned vm id'
});
const MIGRATED_VM_FROM = exports.MIGRATED_VM_FROM = _i18n.i18n.translate('xpack.securitySolution.auditd.migratedVmFromDescription', {
  defaultMessage: 'migrated vm from'
});
const MIGRATED_VM_TO = exports.MIGRATED_VM_TO = _i18n.i18n.translate('xpack.securitySolution.auditd.migratedVmToDescription', {
  defaultMessage: 'migrated vm to'
});
const ASSIGNED_VM_RESOURCE = exports.ASSIGNED_VM_RESOURCE = _i18n.i18n.translate('xpack.securitySolution.auditd.assignedVMResourceDescription', {
  defaultMessage: 'assigned vm resource'
});