"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineContainer = exports.TimelineBodyGlobalStyle = exports.TimelineBody = exports.SELECTOR_TIMELINE_GLOBAL_CONTAINER = exports.SELECTOR_TIMELINE_BODY_CLASS_NAME = exports.HideShowContainer = exports.EventsTrSupplement = exports.EventsTh = exports.EventsTdContent = exports.EVENTS_TABLE_CLASS_NAME = void 0;
var _polished = require("polished");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * TIMELINE BODY
 */
const SELECTOR_TIMELINE_GLOBAL_CONTAINER = exports.SELECTOR_TIMELINE_GLOBAL_CONTAINER = 'securitySolutionTimeline__container';
const TimelineContainer = exports.TimelineContainer = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `${SELECTOR_TIMELINE_GLOBAL_CONTAINER} ${className}`
}))`
  height: 100%;
  display: flex;
  flex-direction: column;
  position: relative;
`;

/**
 * TIMELINE BODY
 */
const SELECTOR_TIMELINE_BODY_CLASS_NAME = exports.SELECTOR_TIMELINE_BODY_CLASS_NAME = 'securitySolutionTimeline__body';

// SIDE EFFECT: the following creates a global class selector
const TimelineBodyGlobalStyle = exports.TimelineBodyGlobalStyle = (0, _styledComponents.createGlobalStyle)`
  body.${_securitysolutionTGrid.IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME} .${SELECTOR_TIMELINE_BODY_CLASS_NAME} {
    overflow: hidden;
  }
`;
const TimelineBody = exports.TimelineBody = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `${SELECTOR_TIMELINE_BODY_CLASS_NAME} ${className}`
}))`
  height: auto;
  overflow: auto;
  scrollbar-width: thin;
  flex: 1;
  display: block;

  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }

  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }

  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
TimelineBody.displayName = 'TimelineBody';

/**
 * EVENTS TABLE
 */

const EVENTS_TABLE_CLASS_NAME = exports.EVENTS_TABLE_CLASS_NAME = 'siemEventsTable';
const EventsTh = exports.EventsTh = _styledComponents.default.div.attrs(({
  className = '',
  role = 'columnheader'
}) => ({
  className: `siemEventsTable__th ${className}`,
  role
}))`
  align-items: center;
  display: flex;
  flex-shrink: 0;
  min-width: 0;

  .siemEventsTable__thGroupActions &:first-child:last-child {
    flex: 1;
  }

  .siemEventsTable__thGroupData &:hover {
    background-color: ${({
  theme
}) => theme.eui.euiTableHoverColor};
    cursor: move; /* Fallback for IE11 */
    cursor: grab;
  }

  > div:focus {
    outline: 0; /* disable focus on Resizable element */
  }

  /* don't display Draggable placeholder */

  [data-rbd-placeholder-context-id] {
    display: none !important;
  }
`;
const EventsTrSupplement = exports.EventsTrSupplement = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsTable__trSupplement ${className}`
}))`
  display: ${({
  $display
}) => $display !== null && $display !== void 0 ? $display : 'inline-block'};
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
  padding-left: ${({
  theme
}) => theme.eui.euiSizeM};

  .euiAccordion + div {
    background-color: ${({
  theme
}) => theme.eui.euiColorEmptyShade};
    padding: 0 ${({
  theme
}) => theme.eui.euiSizeS};
    border: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
    border-radius: ${({
  theme
}) => theme.eui.euiSizeXS};
  }
`;
const EventsTdContent = exports.EventsTdContent = _styledComponents.default.div.attrs(({
  className
}) => ({
  className: `siemEventsTable__tdContent ${className != null ? className : ''}`
}))`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
  min-width: 0;
  text-align: ${({
  textAlign
}) => textAlign};
  width: ${({
  width
}) => width != null ? `${width}px` : '100%'}; /* Using width: 100% instead of flex: 1 and max-width: 100% for IE11 */

  button.euiButtonIcon {
    margin-left: ${({
  theme
}) => `-${theme.eui.euiSizeXS}`};
  }
`;
const HideShowContainer = exports.HideShowContainer = _styledComponents.default.div.attrs(({
  $isVisible = false
}) => ({
  style: {
    display: $isVisible ? 'block' : 'none'
  }
}))``;