"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnalyzeIndexPattern = void 0;
var _langgraph = require("@langchain/langgraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnalyzeIndexPattern = ({
  analyzeIndexPatternGraph
}) => {
  return async ({
    input
  }) => {
    const result = await analyzeIndexPatternGraph.invoke({
      input
    });
    const {
      output
    } = result;
    if (output === undefined) {
      throw new Error('No output from analyze index pattern graph');
    }
    return new _langgraph.Command({
      update: {
        indexPatternAnalysis: {
          [input.indexPattern]: {
            indexPattern: input.indexPattern,
            containsRequiredData: output.containsRequiredFieldsForQuery,
            context: output.context
          }
        }
      }
    });
  };
};
exports.getAnalyzeIndexPattern = getAnalyzeIndexPattern;