"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllIntegrationsRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("@kbn/fleet-plugin/common/constants");
var _constants2 = require("../../../../../../common/detection_engine/constants");
var _utils = require("../../../routes/utils");
var _fleet_integrations = require("../../../../../../common/api/detection_engine/fleet_integrations");
var _extract_integrations = require("./extract_integrations");
var _sort_packages_by_security_category = require("./sort_packages_by_security_category");
var _sort_integrations_by_status = require("./sort_integrations_by_status");
var _get_fleet_packages = require("../../logic/get_fleet_packages");
var _get_package_policies = require("../../logic/get_package_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns an array of Fleet integrations and their packages
 */
const getAllIntegrationsRoute = (router, logger) => {
  router.versioned.get({
    access: 'internal',
    path: _fleet_integrations.GET_ALL_INTEGRATIONS_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '1',
    validate: false
  }, async (context, _, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'securitySolution']);
      const fleet = ctx.securitySolution.getInternalFleetServices();
      const [packages, packagePolicies] = await Promise.all([(0, _get_fleet_packages.getFleetPackages)(fleet, logger), (0, _get_package_policies.getFleetPackagePolicies)(fleet, logger, {
        perPage: _constants.SO_SEARCH_LIMIT
      })]);
      // Elastic prebuilt rules is a special package and should be skipped
      const packagesWithoutPrebuiltSecurityRules = packages.filter(x => x.name !== _constants2.PREBUILT_RULES_PACKAGE_NAME);
      (0, _sort_packages_by_security_category.sortPackagesBySecurityCategory)(packagesWithoutPrebuiltSecurityRules);
      const integrations = (0, _extract_integrations.extractIntegrations)(packagesWithoutPrebuiltSecurityRules, packagePolicies.items);
      (0, _sort_integrations_by_status.sortIntegrationsByStatus)(integrations);
      const body = {
        integrations
      };
      return response.ok({
        body
      });
    } catch (err) {
      logger.error(`getAllIntegrationsRoute: Caught error:`, err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getAllIntegrationsRoute = getAllIntegrationsRoute;