"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMigrationSavedObjects = void 0;
var _Either = require("fp-ts/Either");
var _pipeable = require("fp-ts/pipeable");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _saved_objects_client = require("./saved_objects_client");
var _saved_objects_schema = require("./saved_objects_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findMigrationSavedObjects = async ({
  options,
  soClient
}) => {
  const client = (0, _saved_objects_client.signalsMigrationSOClient)(soClient);
  return (0, _pipeable.pipe)(await client.find(options), so => (0, _securitysolutionIoTsUtils.validateEither)(_saved_objects_schema.signalsMigrationSOs, so.saved_objects), (0, _Either.fold)(e => Promise.reject(e), a => Promise.resolve(a)));
};
exports.findMigrationSavedObjects = findMigrationSavedObjects;