"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installPrebuiltRulesAndTimelinesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _utils = require("../../../routes/utils");
var _constants = require("../../constants");
var _legacy_create_prepackaged_rules = require("./legacy_create_prepackaged_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

const installPrebuiltRulesAndTimelinesRoute = (router, logger) => {
  router.versioned.put({
    access: 'public',
    path: _prebuilt_rules.PREBUILT_RULES_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      timeout: {
        idleSocket: _constants.PREBUILT_RULES_OPERATION_SOCKET_TIMEOUT_MS
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: false
  }, async (context, _, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const rulesClient = await (await context.alerting).getRulesClient();
      const validated = await (0, _legacy_create_prepackaged_rules.legacyCreatePrepackagedRules)(await context.securitySolution, rulesClient, logger, undefined);
      return response.ok({
        body: validated !== null && validated !== void 0 ? validated : {}
      });
    } catch (err) {
      logger.error(`installPrebuiltRulesAndTimelinesRoute: Caught error:`, err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.installPrebuiltRulesAndTimelinesRoute = installPrebuiltRulesAndTimelinesRoute;