"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndicesMetadataPreview = void 0;
var _preview_sender = require("../../../../telemetry/preview_sender");
var _preview_task_metrics = require("../../../../telemetry/preview_task_metrics");
var _indices = require("../../../../telemetry/tasks/indices.metadata");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndicesMetadataPreview = async ({
  logger,
  telemetryReceiver,
  telemetrySender
}) => {
  const taskExecutionPeriod = {
    last: new Date(0).toISOString(),
    current: new Date().toISOString()
  };
  const taskSender = new _preview_sender.PreviewTelemetryEventsSender(logger, telemetrySender);
  const taskMetricsService = new _preview_task_metrics.PreviewTaskMetricsService(logger, taskSender);
  const task = (0, _indices.createTelemetryIndicesMetadataTaskConfig)();
  await task.runTask('indices-metadata-telemetry', logger, telemetryReceiver, taskSender, taskMetricsService, taskExecutionPeriod);
  return taskSender.getEbtEventsSent();
};
exports.getIndicesMetadataPreview = getIndicesMetadataPreview;