"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkCreateSuppressedThresholdAlerts = void 0;
var _reason_formatters = require("../utils/reason_formatters");
var _bulk_create_with_suppression = require("../utils/bulk_create_with_suppression");
var _wrap_suppressed_threshold_alerts = require("./wrap_suppressed_threshold_alerts");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * wraps threshold alerts and creates them using bulkCreateWithSuppression utility
 * returns {@link GenericBulkCreateResponse}
 * and unsuppressed alerts, needed to create correct threshold history
 */
const bulkCreateSuppressedThresholdAlerts = async ({
  sharedParams,
  buckets,
  services,
  startedAt
}) => {
  var _sharedParams$complet;
  const suppressionDuration = (_sharedParams$complet = sharedParams.completeRule.ruleParams.alertSuppression) === null || _sharedParams$complet === void 0 ? void 0 : _sharedParams$complet.duration;
  if (!suppressionDuration) {
    throw Error('Suppression duration can not be empty');
  }
  const suppressionWindow = `now-${suppressionDuration.value}${suppressionDuration.unit}`;
  const wrappedAlerts = (0, _wrap_suppressed_threshold_alerts.wrapSuppressedThresholdALerts)({
    sharedParams,
    buckets,
    buildReasonMessage: _reason_formatters.buildReasonMessageForThresholdAlert,
    startedAt
  });
  const bulkCreateResult = await (0, _bulk_create_with_suppression.bulkCreateWithSuppression)({
    sharedParams,
    wrappedDocs: wrappedAlerts,
    services,
    suppressionWindow
  });
  return {
    bulkCreateResult,
    // if there errors we going to use created items only
    unsuppressedAlerts: bulkCreateResult.errors.length ? (0, _utils.transformBulkCreatedItemsToHits)(bulkCreateResult.createdItems) : wrappedAlerts
  };
};
exports.bulkCreateSuppressedThresholdAlerts = bulkCreateSuppressedThresholdAlerts;