"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformBucketIntoHit = exports.getTransformedHits = exports.bulkCreateThresholdSignals = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _utils = require("./utils");
var _reason_formatters = require("../utils/reason_formatters");
var _factories = require("../factories");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformBucketIntoHit = (bucket, inputIndex, startedAt, from, threshold, ruleId) => {
  var _threshold$cardinalit, _bucket$cardinality_c;
  // In case of absent threshold fields, `bucket.key` will be an empty string. Note that `Object.values('')` is `[]`,
  // so the below logic works in either case (whether `terms` or `composite`).
  return {
    _index: inputIndex,
    _id: (0, _utils.calculateThresholdSignalUuid)(ruleId, startedAt, threshold.field, Object.values(bucket.key).sort().join(',')),
    _source: {
      [_ruleDataUtils.TIMESTAMP]: bucket.max_timestamp.value_as_string,
      ...bucket.key,
      threshold_result: {
        cardinality: (_threshold$cardinalit = threshold.cardinality) !== null && _threshold$cardinalit !== void 0 && _threshold$cardinalit.length ? [{
          field: threshold.cardinality[0].field,
          value: (_bucket$cardinality_c = bucket.cardinality_count) === null || _bucket$cardinality_c === void 0 ? void 0 : _bucket$cardinality_c.value
        }] : undefined,
        count: bucket.doc_count,
        from: bucket.min_timestamp.value_as_string ? new Date(bucket.min_timestamp.value_as_string) : from,
        terms: Object.entries(bucket.key).map(([key, val]) => ({
          field: key,
          value: val
        }))
      }
    }
  };
};
exports.transformBucketIntoHit = transformBucketIntoHit;
const getTransformedHits = (buckets, inputIndex, startedAt, from, threshold, ruleId) => buckets.map((bucket, i) => {
  return transformBucketIntoHit(bucket, inputIndex, startedAt, from, threshold, ruleId);
});
exports.getTransformedHits = getTransformedHits;
const bulkCreateThresholdSignals = async ({
  sharedParams,
  buckets,
  services,
  startedAt
}) => {
  const ruleParams = sharedParams.completeRule.ruleParams;
  const ecsResults = getTransformedHits(buckets, sharedParams.inputIndex.join(','), startedAt, sharedParams.tuple.from.toDate(), ruleParams.threshold, ruleParams.ruleId);
  return (0, _factories.bulkCreate)({
    wrappedAlerts: (0, _factories.wrapHits)(sharedParams, ecsResults, _reason_formatters.buildReasonMessageForThresholdAlert),
    sharedParams,
    services
  });
};
exports.bulkCreateThresholdSignals = bulkCreateThresholdSignals;