"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetCriticalityPublicGetRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _constants = require("../../../../../common/constants");
var _check_and_init_asset_criticality_resources = require("../check_and_init_asset_criticality_resources");
var _audit = require("../audit");
var _audit2 = require("../../audit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetCriticalityPublicGetRoute = (router, logger) => {
  router.versioned.get({
    access: 'public',
    path: _constants.ASSET_CRITICALITY_PUBLIC_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_entity_analytics.GetAssetCriticalityRecordRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      var _securitySolution$get;
      await (0, _check_and_init_asset_criticality_resources.checkAndInitAssetCriticalityResources)(context, logger);
      const securitySolution = await context.securitySolution;
      const assetCriticalityClient = securitySolution.getAssetCriticalityDataClient();
      const record = await assetCriticalityClient.get({
        idField: request.query.id_field,
        idValue: request.query.id_value
      });
      if (!record) {
        return response.notFound();
      }
      (_securitySolution$get = securitySolution.getAuditLogger()) === null || _securitySolution$get === void 0 ? void 0 : _securitySolution$get.log({
        message: 'User accessed the criticality level for an entity',
        event: {
          action: _audit.AssetCriticalityAuditActions.ASSET_CRITICALITY_GET,
          category: _audit2.AUDIT_CATEGORY.DATABASE,
          type: _audit2.AUDIT_TYPE.ACCESS,
          outcome: _audit2.AUDIT_OUTCOME.SUCCESS
        }
      });
      return response.ok({
        body: record
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.assetCriticalityPublicGetRoute = assetCriticalityPublicGetRoute;