"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskScorePreviewRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _constants = require("../../../../../common/constants");
var _get_risk_inputs_index = require("../get_risk_inputs_index");
var _audit = require("../audit");
var _audit2 = require("../../audit");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskScorePreviewRoute = (router, logger) => {
  router.versioned.post({
    access: 'internal',
    path: _constants.RISK_SCORE_PREVIEW_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_entity_analytics.RiskScoresPreviewRequest)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const securityContext = await context.securitySolution;
    const coreContext = await context.core;
    const soClient = coreContext.savedObjects.client;
    const securityConfig = await securityContext.getConfig();
    const riskScoreService = (0, _helpers.buildRiskScoreServiceForRequest)(securityContext, coreContext, logger);
    const {
      after_keys: userAfterKeys,
      data_view_id: dataViewId,
      debug,
      page_size: userPageSize,
      identifier_type: identifierType,
      filter,
      range: userRange,
      weights,
      exclude_alert_statuses: excludedStatuses,
      exclude_alert_tags: excludedTags
    } = request.body;
    const entityAnalyticsConfig = await riskScoreService.getConfigurationWithDefaults(securityConfig.entityAnalytics);
    const alertSampleSizePerShard = entityAnalyticsConfig === null || entityAnalyticsConfig === void 0 ? void 0 : entityAnalyticsConfig.alertSampleSizePerShard;
    try {
      var _securityContext$getA;
      const {
        index,
        runtimeMappings
      } = await (0, _get_risk_inputs_index.getRiskInputsIndex)({
        dataViewId,
        logger,
        soClient
      });
      const afterKeys = userAfterKeys !== null && userAfterKeys !== void 0 ? userAfterKeys : {};
      const range = userRange !== null && userRange !== void 0 ? userRange : {
        start: 'now-15d',
        end: 'now'
      };
      const pageSize = userPageSize !== null && userPageSize !== void 0 ? userPageSize : _constants.DEFAULT_RISK_SCORE_PAGE_SIZE;
      const excludeAlertStatuses = excludedStatuses || ['closed'];
      const excludeAlertTags = excludedTags || [];
      const result = await riskScoreService.calculateScores({
        afterKeys,
        debug,
        filter,
        identifierType: identifierType,
        index,
        pageSize,
        range,
        runtimeMappings,
        weights,
        alertSampleSizePerShard,
        excludeAlertStatuses,
        excludeAlertTags
      });
      (_securityContext$getA = securityContext.getAuditLogger()) === null || _securityContext$getA === void 0 ? void 0 : _securityContext$getA.log({
        message: 'User triggered custom manual scoring',
        event: {
          action: _audit.RiskScoreAuditActions.RISK_ENGINE_PREVIEW,
          category: _audit2.AUDIT_CATEGORY.DATABASE,
          type: _audit2.AUDIT_TYPE.CHANGE,
          outcome: _audit2.AUDIT_OUTCOME.SUCCESS
        }
      });
      return response.ok({
        body: result
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.riskScorePreviewRoute = riskScorePreviewRoute;