"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertAdvancedSettingsEnabled = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assertAdvancedSettingsEnabled = async (core, settingId) => {
  const isAdvancedSettingsEnabled = await core.uiSettings.client.get(settingId);
  if (!isAdvancedSettingsEnabled) {
    const err = new Error(`Advanced Settings ${settingId} is disabled.`);
    err.statusCode = 403;
    throw err;
  }
};
exports.assertAdvancedSettingsEnabled = assertAdvancedSettingsEnabled;