"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemDashboardMigrationsInstallRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../common/siem_migrations/dashboards/constants");
var _dashboard_migration = require("../../../../../common/siem_migrations/model/api/dashboards/dashboard_migration.gen");
var _authz = require("../../common/api/util/authz");
var _with_license = require("../../common/api/util/with_license");
var _with_existing_migration_id = require("../../common/api/util/with_existing_migration_id");
var _audit = require("../../common/api/util/audit");
var _installation = require("./util/installation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemDashboardMigrationsInstallRoute = (router, logger) => {
  router.versioned.post({
    path: _constants.SIEM_DASHBOARD_MIGRATION_INSTALL_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_dashboard_migration.InstallMigrationDashboardsRequestParams),
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_dashboard_migration.InstallMigrationDashboardsRequestBody)
      }
    }
  }, (0, _with_license.withLicense)((0, _with_existing_migration_id.withExistingMigration)(async (context, req, res) => {
    const {
      migration_id: migrationId
    } = req.params;
    const {
      ids
    } = req.body;
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution, 'dashboards');
    try {
      const ctx = await context.resolve(['core', 'securitySolution']);
      const securitySolutionContext = ctx.securitySolution;
      const savedObjectsClient = ctx.core.savedObjects.client;
      const spaceId = ctx.securitySolution.getSpaceId();
      await siemMigrationAuditLogger.logInstallDashboards({
        ids,
        migrationId
      });
      const installed = await (0, _installation.installTranslated)({
        migrationId,
        ids,
        securitySolutionContext,
        savedObjectsClient,
        spaceId
      });
      return res.ok({
        body: {
          installed
        }
      });
    } catch (error) {
      logger.error(error);
      await siemMigrationAuditLogger.logInstallDashboards({
        ids,
        migrationId,
        error
      });
      return res.badRequest({
        body: error.message
      });
    }
  })));
};
exports.registerSiemDashboardMigrationsInstallRoute = registerSiemDashboardMigrationsInstallRoute;