"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsIntegrationsRoute = void 0;
var _constants = require("../../../../../common/siem_migrations/constants");
var _authz = require("../../common/api/util/authz");
var _with_license = require("../../common/api/util/with_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsIntegrationsRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_RULE_MIGRATIONS_INTEGRATIONS_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, (0, _with_license.withLicense)(async (context, req, res) => {
    try {
      const ctx = await context.resolve(['core', 'alerting', 'securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.siemMigrations.getRulesClient();
      const relatedIntegrations = {};
      const packages = await ruleMigrationsClient.data.integrations.getSecurityLogsPackages();
      packages === null || packages === void 0 ? void 0 : packages.forEach(({
        id,
        version,
        integration
      }) => {
        relatedIntegrations[id] = {
          package: id,
          version,
          integration
        };
      });
      return res.ok({
        body: relatedIntegrations
      });
    } catch (err) {
      logger.error(err);
      return res.badRequest({
        body: err.message
      });
    }
  }));
};
exports.registerSiemRuleMigrationsIntegrationsRoute = registerSiemRuleMigrationsIntegrationsRoute;