"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemReadinessRoutes = void 0;
var _post_readiness_task = require("./routes/post_readiness_task");
var _get_latest_readiness_tasks = require("./routes/get_latest_readiness_tasks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemReadinessRoutes = ({
  router,
  logger
}) => {
  (0, _post_readiness_task.postReadinessTaskRoute)(router, logger);
  (0, _get_latest_readiness_tasks.getLatestReadinessTaskRoute)(router, logger);
};
exports.registerSiemReadinessRoutes = registerSiemReadinessRoutes;