"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.namespaceTypeArray = exports.DefaultNamespaceArray = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _default_namespace = require("../default_namespace");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const namespaceTypeArray = exports.namespaceTypeArray = t.array(_default_namespace.namespaceType);
/**
 * Types the DefaultNamespaceArray as:
 *   - If null or undefined, then a default string array of "single" will be used.
 *   - If it contains a string, then it is split along the commas and puts them into an array and validates it
 */
const DefaultNamespaceArray = exports.DefaultNamespaceArray = new t.Type('DefaultNamespaceArray', namespaceTypeArray.is, (input, context) => {
  if (input == null) {
    return t.success(['single']);
  } else if (typeof input === 'string') {
    const commaSeparatedValues = input.trim().split(',').map(value => value.trim());
    return namespaceTypeArray.validate(commaSeparatedValues, context);
  }
  return t.failure(input, context);
}, String);