"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildForecastedSlo = buildForecastedSlo;
exports.buildSlo = buildSlo;
exports.sloList = exports.emptySloList = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _lodash = require("lodash");
var _uuid = require("uuid");
var _common = require("./common");
var _indicator = require("./indicator");
var _time_window = require("./time_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptySloList = exports.emptySloList = {
  results: [],
  page: 1,
  perPage: 25,
  total: 0
};
const now = '2022-12-29T10:11:12.000Z';
const baseSlo = {
  name: 'super important level service',
  description: 'some description useful',
  indicator: {
    type: 'sli.kql.custom',
    params: {
      index: 'some-index',
      filter: 'baz: foo and bar > 2',
      good: 'http_status: 2xx',
      total: 'a query',
      timestampField: 'custom_timestamp',
      dataViewId: 'some-data-view-id'
    }
  },
  timeWindow: {
    duration: '30d',
    type: 'rolling'
  },
  objective: {
    target: 0.98
  },
  budgetingMethod: 'occurrences',
  revision: 1,
  settings: {
    syncDelay: '1m',
    frequency: '1m',
    preventInitialBackfill: false
  },
  summary: {
    status: 'HEALTHY',
    sliValue: 0.99872,
    errorBudget: {
      initial: 0.02,
      consumed: 0.064,
      remaining: 0.936,
      isEstimated: false
    },
    fiveMinuteBurnRate: 0,
    oneHourBurnRate: 0,
    oneDayBurnRate: 0
  },
  groupBy: _sloSchema.ALL_VALUE,
  groupings: {},
  instanceId: _sloSchema.ALL_VALUE,
  tags: ['k8s', 'production', 'critical'],
  enabled: true,
  createdAt: now,
  updatedAt: now,
  version: 2,
  meta: {}
};
const sloList = exports.sloList = {
  results: [{
    ...baseSlo,
    id: '1f1c6ee7-433f-4b56-b727-5682262e0d7d',
    indicator: (0, _indicator.buildCustomKqlIndicator)(),
    summary: (0, _common.buildHealthySummary)(),
    timeWindow: (0, _time_window.buildRollingTimeWindow)()
  }, {
    ...baseSlo,
    id: '1f1c6ee7-433f-4b56-b727-5682262e0d7e',
    indicator: (0, _indicator.buildApmAvailabilityIndicator)(),
    summary: (0, _common.buildHealthySummary)(),
    timeWindow: (0, _time_window.buildCalendarAlignedTimeWindow)()
  }, {
    ...baseSlo,
    id: 'c0f8d669-9177-4706-9098-f397a88173a6',
    summary: (0, _common.buildViolatedSummary)(),
    indicator: (0, _indicator.buildApmAvailabilityIndicator)(),
    timeWindow: (0, _time_window.buildCalendarAlignedTimeWindow)()
  }, {
    ...baseSlo,
    id: 'c0f8d669-9277-4706-9098-f397a88173a6',
    summary: (0, _common.buildViolatedSummary)(),
    timeWindow: (0, _time_window.buildRollingTimeWindow)({
      duration: '7d'
    })
  }, {
    ...baseSlo,
    id: 'c0f8d669-9177-4706-9098-f397a88173a7',
    summary: (0, _common.buildNoDataSummary)()
  }, {
    ...baseSlo,
    id: 'c0f8d669-9177-4706-9098-f397a88173b7',
    summary: (0, _common.buildNoDataSummary)(),
    indicator: (0, _indicator.buildApmAvailabilityIndicator)(),
    timeWindow: (0, _time_window.buildCalendarAlignedTimeWindow)()
  }, {
    ...baseSlo,
    id: 'c0f8d669-9177-4706-9098-f397a88173a8',
    budgetingMethod: 'timeslices',
    timeWindow: (0, _time_window.buildCalendarAlignedTimeWindow)(),
    objective: (0, _common.buildTimeslicesObjective)(),
    summary: (0, _common.buildDegradingSummary)()
  }, {
    ...baseSlo,
    id: 'c0f8d669-9177-4706-9098-f397a88173a9',
    objective: (0, _common.buildOccurrencesObjective)(),
    timeWindow: (0, _time_window.buildCalendarAlignedTimeWindow)(),
    summary: (0, _common.buildDegradingSummary)(),
    indicator: (0, _indicator.buildApmAvailabilityIndicator)()
  }],
  page: 1,
  perPage: 25,
  total: 4
};
function buildForecastedSlo(params = {}) {
  return buildSlo({
    timeWindow: (0, _time_window.buildCalendarAlignedTimeWindow)(),
    summary: (0, _common.buildHealthySummary)({
      errorBudget: {
        initial: 0.02,
        consumed: 0.064,
        remaining: 0.936,
        isEstimated: true
      }
    }),
    ...params
  });
}
function buildSlo(params = {}) {
  return (0, _lodash.cloneDeep)({
    ...baseSlo,
    id: (0, _uuid.v4)(),
    ...params
  });
}