"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloBurnRates = useFetchSloBurnRates;
var _sloSchema = require("@kbn/slo-schema");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../constants");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloBurnRates({
  slo,
  windows,
  shouldRefetch
}) {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    isLoading,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.burnRates(slo.id, slo.instanceId, windows),
    queryFn: async ({
      signal
    }) => {
      try {
        var _slo$instanceId, _slo$remote;
        const response = await sloClient.fetch('POST /internal/observability/slos/{id}/_burn_rates', {
          params: {
            path: {
              id: slo.id
            },
            body: {
              windows,
              instanceId: (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE,
              remoteName: (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName
            }
          },
          signal
        });
        return response;
      } catch (error) {
        // ignore error
      }
    },
    refetchInterval: shouldRefetch ? _constants.SLO_LONG_REFETCH_INTERVAL : undefined,
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    refetch
  };
}