"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloInspect = useFetchSloInspect;
var _reactQuery = require("@kbn/react-query");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloInspect(slo, shouldInspect) {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    isLoading,
    isError,
    isSuccess,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['slo', 'inspect'],
    queryFn: async ({
      signal
    }) => {
      try {
        return await sloClient.fetch('POST /internal/observability/slos/_inspect', {
          params: {
            body: slo
          },
          signal
        });
      } catch (error) {
        // ignore error
      }
    },
    enabled: shouldInspect,
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isSuccess,
    isError
  };
}