"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Definition = Definition;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _labels = require("../../../../utils/slo/labels");
var _apm_indicator_overview = require("../overview/apm_indicator_overview");
var _display_query = require("../overview/display_query");
var _definition_item = require("./definition_item");
var _synthetics_indicator_overview = require("../overview/synthetics_indicator_overview");
var _linked_dashboards = require("./linked_dashboards");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/definition/definition.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Definition({
  slo
}) {
  var _slo$artifacts$dashbo, _slo$artifacts;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  let IndicatorOverview = null;
  switch (slo.indicator.type) {
    case 'sli.apm.transactionDuration':
    case 'sli.apm.transactionErrorRate':
      IndicatorOverview = /*#__PURE__*/_react.default.createElement(_apm_indicator_overview.ApmIndicatorOverview, {
        slo: slo,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 27
        }
      });
      break;
    case 'sli.synthetics.availability':
      IndicatorOverview = /*#__PURE__*/_react.default.createElement(_synthetics_indicator_overview.SyntheticsIndicatorOverview, {
        slo: slo,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 27
        }
      });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    color: "transparent",
    "data-test-subj": "definition",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: isMobile ? 2 : 4,
    gutterSize: "l",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.indicatorTypeTitle', {
      defaultMessage: 'Indicator type'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 21
      }
    }, (0, _labels.toIndicatorTypeLabel)(slo.indicator.type)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.timeWindowTitle', {
      defaultMessage: 'Time window'
    }),
    subtitle: toTimeWindowLabel(slo.timeWindow),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.budgetingMethodTitle', {
      defaultMessage: 'Budgeting method'
    }),
    subtitle: _sloSchema.occurrencesBudgetingMethodSchema.is(slo.budgetingMethod) ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    }, _labels.BUDGETING_METHOD_OCCURRENCES) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 15
      }
    }, _labels.BUDGETING_METHOD_TIMESLICES, " (", slo.indicator.type === 'sli.metric.timeslice' ? _i18n.i18n.translate('xpack.slo.sloDetails.overview.timeslicesBudgetingMethodDetailsForTimesliceMetric', {
      defaultMessage: '{duration} slices',
      values: {
        duration: (0, _labels.toDurationLabel)(slo.objective.timesliceWindow)
      }
    }) : _i18n.i18n.translate('xpack.slo.sloDetails.overview.timeslicesBudgetingMethodDetails', {
      defaultMessage: '{duration} slices, {target} target',
      values: {
        duration: (0, _labels.toDurationLabel)(slo.objective.timesliceWindow),
        target: (0, _numeral.default)(slo.objective.timesliceTarget).format(percentFormat)
      }
    }), ")"),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }), IndicatorOverview, 'index' in slo.indicator.params && /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.indexTitle', {
      defaultMessage: 'Index pattern'
    }),
    subtitle: slo.indicator.params.index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }), 'filter' in slo.indicator.params && /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.overallQueryTitle', {
      defaultMessage: 'Overall query'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_display_query.DisplayQuery, {
      query: slo.indicator.params.filter,
      index: slo.indicator.params.index,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }), 'good' in slo.indicator.params && _sloSchema.querySchema.is(slo.indicator.params.good) && /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.goodQueryTitle', {
      defaultMessage: 'Good query'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_display_query.DisplayQuery, {
      query: slo.indicator.params.good,
      index: slo.indicator.params.index,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }), 'total' in slo.indicator.params && _sloSchema.querySchema.is(slo.indicator.params.total) && /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.totalQueryTitle', {
      defaultMessage: 'Total query'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_display_query.DisplayQuery, {
      query: slo.indicator.params.total,
      index: slo.indicator.params.index,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.settings.syncDelay', {
      defaultMessage: 'Sync delay'
    }),
    subtitle: slo.settings.syncDelay,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.settings.frequency', {
      defaultMessage: 'Frequency'
    }),
    subtitle: slo.settings.frequency,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.dashboards', {
      defaultMessage: 'Linked dashboards'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_linked_dashboards.LinkedDashboards, {
      dashboards: (_slo$artifacts$dashbo = (_slo$artifacts = slo.artifacts) === null || _slo$artifacts === void 0 ? void 0 : _slo$artifacts.dashboards) !== null && _slo$artifacts$dashbo !== void 0 ? _slo$artifacts$dashbo : [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 21
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  })));
}
function toTimeWindowLabel(timeWindow) {
  if (_sloSchema.rollingTimeWindowTypeSchema.is(timeWindow.type)) {
    return _i18n.i18n.translate('xpack.slo.sloDetails.overview.rollingTimeWindow', {
      defaultMessage: '{duration} rolling',
      values: {
        duration: (0, _labels.toDurationLabel)(timeWindow.duration)
      }
    });
  }
  return _i18n.i18n.translate('xpack.slo.sloDetails.overview.calendarAlignedTimeWindow', {
    defaultMessage: '{duration} calendar aligned',
    values: {
      duration: (0, _labels.toDurationAdverbLabel)(timeWindow.duration)
    }
  });
}