"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderTitle = HeaderTitle;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _slo_badges = require("../../../components/slo/slo_badges");
var _slo_tags_badge = require("../../../components/slo/slo_badges/slo_tags_badge");
var _slo_remote_badge = require("../../slos/components/badges/slo_remote_badge");
var _slo_groupings = require("./groupings/slo_groupings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/header_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function HeaderTitle({
  isLoading,
  slo
}) {
  var _slo$updatedBy;
  if (isLoading || !slo) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 2,
      "data-test-subj": "loadingTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexStart",
    responsive: false,
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_badges.SloValueBadge, {
    slo: slo,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_badges.SloStatusBadge, {
    slo: slo,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_badges.SloStateBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_remote_badge.SloRemoteBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_tags_badge.SloTagsBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  })), slo.description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: 'eui-textBreakWord',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "xs",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, slo.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "xs",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.slo.sloDetails.headerTitle.lastUpdatedLabel', {
    defaultMessage: '**Last updated by** {updatedBy} **on** {updatedAt}',
    values: {
      updatedBy: (_slo$updatedBy = slo.updatedBy) !== null && _slo$updatedBy !== void 0 ? _slo$updatedBy : NOT_AVAILABLE_LABEL,
      updatedAt: (0, _moment.default)(slo.updatedAt).format('ll')
    }
  }))), /*#__PURE__*/_react.default.createElement(_slo_groupings.SLOGroupings, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }));
}
const NOT_AVAILABLE_LABEL = _i18n.i18n.translate('xpack.slo.sloDetails.headerTitle.notAvailableLabel', {
  defaultMessage: 'n/a'
});