"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloTimeWindowBadge = SloTimeWindowBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _paths = require("../../../../../common/locators/paths");
var _duration = require("../../../../utils/slo/duration");
var _labels = require("../../../../utils/slo/labels");
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/badges/slo_time_window_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloTimeWindowBadge({
  slo
}) {
  var _useRouteMatch$isExac, _useRouteMatch;
  const {
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const isSloPage = (_useRouteMatch$isExac = (_useRouteMatch = (0, _reactRouterDom.useRouteMatch)(_paths.SLOS_PATH)) === null || _useRouteMatch === void 0 ? void 0 : _useRouteMatch.isExact) !== null && _useRouteMatch$isExac !== void 0 ? _useRouteMatch$isExac : false;
  const onBadgeClick = (0, _react.useCallback)(() => {
    if (isSloPage) onStateChange({
      kqlQuery: `slo.timeWindow.duration: "${slo.timeWindow.duration}"`
    });
  }, [isSloPage, onStateChange, slo.timeWindow.duration]);
  const unit = slo.timeWindow.duration.slice(-1);
  if (_sloSchema.rollingTimeWindowTypeSchema.is(slo.timeWindow.type)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      onClick: onBadgeClick,
      onClickAriaLabel: _i18n.i18n.translate('xpack.slo.timeWindowBadge.clickToFilter', {
        defaultMessage: 'Click to filter by {timeWindow} SLOs',
        values: {
          timeWindow: (0, _labels.toDurationLabel)(slo.timeWindow.duration)
        }
      }),
      iconType: "editorItemAlignRight",
      iconSide: "left",
      onMouseDown: e => {
        if (isSloPage) e.stopPropagation(); // stops propagation of metric onElementClick
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }, (0, _labels.toDurationLabel)(slo.timeWindow.duration)));
  }
  const unitMoment = (0, _duration.toCalendarAlignedMomentUnitOfTime)(unit);
  const now = _moment.default.utc();
  const periodStart = now.clone().startOf(unitMoment);
  const periodEnd = now.clone().endOf(unitMoment);
  const totalDurationInDays = periodEnd.diff(periodStart, 'days') + 1;
  const elapsedDurationInDays = now.diff(periodStart, 'days') + 1;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "calendar",
    iconSide: "left",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.slo.slo.timeWindow.calendar', {
    defaultMessage: '{elapsed}/{total} days',
    values: {
      elapsed: Math.min(elapsedDurationInDays, totalDurationInDays),
      total: totalDurationInDays
    }
  })));
}