"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toErrorBudget = toErrorBudget;
var _number = require("../../utils/number");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toErrorBudget(initial, consumed, isEstimated = false) {
  return {
    initial: (0, _number.toHighPrecision)(initial),
    consumed: (0, _number.toHighPrecision)(consumed),
    remaining: (0, _number.toHighPrecision)(1 - consumed),
    isEstimated
  };
}