"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSloServerRoute = void 0;
var _serverRouteRepository = require("@kbn/server-route-repository");
var _boom = require("@hapi/boom");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function handleSLOError(error) {
  if (error instanceof _errors.SLONotFound) {
    return (0, _boom.notFound)(error.message);
  }
  if (error instanceof _errors.SLOIdConflict) {
    return (0, _boom.conflict)(error.message);
  }
  if (error instanceof _errors.SecurityException) {
    return (0, _boom.forbidden)(error.message);
  }
  return (0, _boom.badRequest)(error.message);
}
const createPlainSloServerRoute = (0, _serverRouteRepository.createServerRouteFactory)();
const createSloServerRoute = ({
  handler,
  ...config
}) => {
  return createPlainSloServerRoute({
    ...config,
    handler: options => {
      return handler(options).catch(error => {
        if (error instanceof _errors.SLOError) {
          throw handleSLOError(error);
        }
        throw error;
      });
    }
  });
};
exports.createSloServerRoute = createSloServerRoute;