"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDefinitionClient = void 0;
var _constants = require("../../common/constants");
var _remote_summary_doc_to_slo = require("./unsafe_federated/remote_summary_doc_to_slo");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SloDefinitionClient {
  constructor(repository, esClient, logger) {
    this.repository = repository;
    this.esClient = esClient;
    this.logger = logger;
  }
  async execute(sloId, spaceId, remoteName) {
    if (remoteName) {
      var _doc$kibanaUrl;
      const summarySearch = await this.esClient.search({
        index: `${remoteName}:${_constants.SUMMARY_DESTINATION_INDEX_PATTERN}`,
        query: {
          bool: {
            filter: [{
              term: {
                spaceId
              }
            }, {
              term: {
                'slo.id': sloId
              }
            }]
          }
        }
      });
      if (summarySearch.hits.hits.length === 0) {
        throw new Error(`Remote SLO [id=${sloId}, spaceId=${spaceId}, remoteName=${remoteName}] not found`);
      }
      const doc = summarySearch.hits.hits[0]._source;
      const remoteSloDefinition = (0, _remote_summary_doc_to_slo.fromRemoteSummaryDocumentToSloDefinition)(doc, this.logger);
      if (!remoteSloDefinition) {
        throw new Error(`Remote SLO [id=${sloId}, spaceId=${spaceId}, remoteName=${remoteName}] is invalid`);
      }
      return {
        slo: remoteSloDefinition,
        remote: {
          kibanaUrl: (_doc$kibanaUrl = doc.kibanaUrl) !== null && _doc$kibanaUrl !== void 0 ? _doc$kibanaUrl : '',
          remoteName
        }
      };
    }
    const localSloDefinition = await this.repository.findById(sloId);
    return {
      slo: localSloDefinition
    };
  }
}
exports.SloDefinitionClient = SloDefinitionClient;