"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRedirectLegacyUrl = createRedirectLegacyUrl;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createRedirectLegacyUrl(getStartServices) {
  return async function ({
    path,
    aliasPurpose,
    objectNoun = _constants.DEFAULT_OBJECT_NOUN
  }) {
    const [{
      notifications,
      application
    }] = await getStartServices();
    const {
      currentAppId$,
      navigateToApp
    } = application;
    const appId = await currentAppId$.pipe((0, _rxjs.first)()).toPromise(); // retrieve the most recent value from the BehaviorSubject

    if (aliasPurpose === 'savedObjectConversion') {
      const title = _i18n.i18n.translate('xpack.spaces.redirectLegacyUrlToast.title', {
        defaultMessage: `We redirected you to a new URL`
      });
      const text = _i18n.i18n.translate('xpack.spaces.redirectLegacyUrlToast.text', {
        defaultMessage: `The {objectNoun} you're looking for has a new location. Use this URL from now on.`,
        values: {
          objectNoun
        }
      });
      notifications.toasts.addInfo({
        title,
        text
      });
    }
    await navigateToApp(appId, {
      replace: true,
      path
    });
  };
}