"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTabs = void 0;
var _react = require("react");
var _edit_space_tabs = require("../edit_space_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTabs = ({
  space,
  features,
  currentSelectedTabId,
  ...getTabsArgs
}) => {
  const [tabs, selectedTabContent] = (0, _react.useMemo)(() => {
    var _tabs$find;
    if (space === null || features === null) {
      return [[]];
    }
    const _tabs = space != null ? (0, _edit_space_tabs.getTabs)({
      space,
      features,
      ...getTabsArgs
    }) : [];
    return [_tabs, (_tabs$find = _tabs.find(obj => obj.id === currentSelectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content];
  }, [space, features, getTabsArgs, currentSelectedTabId]);
  return [tabs, selectedTabContent];
};
exports.useTabs = useTabs;