"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortRolesForListing = sortRolesForListing;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Roles in the listing must be sorted so that custom roles appear in the beginning
 * and reserved roles appear at the end
 */
function sortRolesForListing(aRole, bRole) {
  var _aMeta$_reserved, _bMeta$_reserved;
  const {
    name: aName,
    metadata: aMeta
  } = aRole;
  const {
    name: bName,
    metadata: bMeta
  } = bRole;
  const aReserved = (_aMeta$_reserved = aMeta === null || aMeta === void 0 ? void 0 : aMeta._reserved) !== null && _aMeta$_reserved !== void 0 ? _aMeta$_reserved : false;
  const bReserved = (_bMeta$_reserved = bMeta === null || bMeta === void 0 ? void 0 : bMeta._reserved) !== null && _bMeta$_reserved !== void 0 ? _bMeta$_reserved : false;
  if (aReserved && !bReserved) {
    return 1;
  }
  if (!aReserved && bReserved) {
    return -1;
  }
  return aName.localeCompare(bName);
}