"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareModeControl = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _selectable_spaces_control = require("./selectable_spaces_control");
var _constants = require("../../../common/constants");
var _spaces_context = require("../../spaces_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/share_saved_objects_to_space/components/share_mode_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const buttonGroupLegend = _i18n.i18n.translate('xpack.spaces.shareToSpace.shareModeControl.buttonGroupLegend', {
  defaultMessage: 'Choose how this is shared'
});
const shareToAllSpacesId = 'shareToAllSpacesId';
const shareToAllSpacesButtonLabel = _i18n.i18n.translate('xpack.spaces.shareToSpace.shareModeControl.shareToAllSpaces.buttonLabel', {
  defaultMessage: 'All spaces'
});
const shareToExplicitSpacesId = 'shareToExplicitSpacesId';
const shareToExplicitSpacesButtonLabel = _i18n.i18n.translate('xpack.spaces.shareToSpace.shareModeControl.shareToExplicitSpaces.buttonLabel', {
  defaultMessage: 'Select spaces'
});
const CANNOT_CHANGE_TOOLTIP = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.spaces.shareToSpace.shareModeControl.shareToAllSpaces.cannotChangeTooltip', {
    defaultMessage: 'You need additional privileges to change this option.'
  }),
  position: "left",
  type: "info",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 3
  }
});
const ALL_SPACES_PROHIBITED_TOOLTIP = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  title: _i18n.i18n.translate('xpack.spaces.shareToSpace.shareModeControl.shareToAllSpaces.allSpacesProhibitedTooltipTitle', {
    defaultMessage: 'Cannot share to all spaces'
  }),
  content: _i18n.i18n.translate('xpack.spaces.shareToSpace.shareModeControl.shareToAllSpaces.allSpacesProhibitedTooltipContent', {
    defaultMessage: 'A copy of this saved object or a related object exists in at least one other space.'
  }),
  position: "left",
  type: "info",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 3
  }
});
const ShareModeControl = props => {
  const {
    spaces,
    objectNoun,
    canShareToAllSpaces,
    shareOptions,
    onChange,
    enableCreateNewSpaceLink,
    enableSpaceAgnosticBehavior,
    prohibitedSpaces
  } = props;
  const {
    services
  } = (0, _spaces_context.useSpaces)();
  const {
    docLinks
  } = services;
  if (spaces.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 12
      }
    });
  }
  const {
    selectedSpaceIds
  } = shareOptions;
  const isGlobalControlChecked = selectedSpaceIds.includes(_constants.ALL_SPACES_ID);
  const getPrivilegeWarning = () => {
    if (canShareToAllSpaces || !isGlobalControlChecked) {
      return null;
    }
    const docLink = docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.security.kibanaPrivileges;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      iconType: "question",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.shareToSpace.privilegeWarningTitle",
        defaultMessage: "Additional privileges required",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 13
        }
      }),
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.shareToSpace.privilegeWarningBody",
      defaultMessage: "To edit the spaces for this {objectNoun}, you need {readAndWritePrivilegesLink} in all spaces.",
      values: {
        objectNoun,
        readAndWritePrivilegesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLink,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 134,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.spaces.shareToSpace.privilegeWarningLink",
          defaultMessage: "read and write privileges",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }));
  };
  const isGlobalControlChangeProhibited = prohibitedSpaces.size > 0 && !isGlobalControlChecked;
  let globalControlTooltip = null;
  if (!canShareToAllSpaces) {
    globalControlTooltip = CANNOT_CHANGE_TOOLTIP;
  } else if (isGlobalControlChangeProhibited) {
    globalControlTooltip = ALL_SPACES_PROHIBITED_TOOLTIP;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getPrivilegeWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    type: "single",
    idSelected: isGlobalControlChecked ? shareToAllSpacesId : shareToExplicitSpacesId,
    options: [{
      id: shareToExplicitSpacesId,
      label: shareToExplicitSpacesButtonLabel
    }, {
      id: shareToAllSpacesId,
      label: shareToAllSpacesButtonLabel
    }],
    onChange: optionId => {
      const updatedSpaceIds = optionId === shareToAllSpacesId ? [_constants.ALL_SPACES_ID, ...selectedSpaceIds] : selectedSpaceIds.filter(id => id !== _constants.ALL_SPACES_ID);
      onChange(updatedSpaceIds);
    },
    legend: buttonGroupLegend,
    color: "text",
    isFullWidth: true,
    isDisabled: !canShareToAllSpaces || isGlobalControlChangeProhibited,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: "center",
    size: "s",
    "data-test-subj": "share-mode-control-description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, isGlobalControlChecked ? _i18n.i18n.translate('xpack.spaces.shareToSpace.shareModeControl.shareToAllSpaces.text', {
    defaultMessage: 'Make {objectNoun} available in all current and future spaces.',
    values: {
      objectNoun
    }
  }) : _i18n.i18n.translate('xpack.spaces.shareToSpace.shareModeControl.shareToExplicitSpaces.text', {
    defaultMessage: 'Make {objectNoun} available in selected spaces only.',
    values: {
      objectNoun
    }
  }))), globalControlTooltip && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 36
    }
  }, globalControlTooltip))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_selectable_spaces_control.SelectableSpacesControl, {
    spaces: spaces,
    shareOptions: shareOptions,
    onChange: onChange,
    enableCreateNewSpaceLink: enableCreateNewSpaceLink,
    enableSpaceAgnosticBehavior: enableSpaceAgnosticBehavior,
    prohibitedSpaces: prohibitedSpaces,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  })));
};
exports.ShareModeControl = ShareModeControl;