"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceAvatarInternal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _space_attributes = require("./space_attributes");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/space_avatar/space_avatar_internal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SpaceAvatarInternal = props => {
  const {
    space,
    size,
    announceSpaceName,
    ...rest
  } = props;
  const spaceName = space.name ? space.name.trim() : '';
  const spaceColor = (0, _space_attributes.getSpaceColor)(space);
  const spaceInitials = (0, _space_attributes.getSpaceInitials)(space);
  const spaceImageUrl = (0, _space_attributes.getSpaceImageUrl)(space);
  const avatarConfig = spaceImageUrl ? {
    imageUrl: spaceImageUrl
  } : {
    initials: spaceInitials,
    initialsLength: _common.MAX_SPACE_INITIALS
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, (0, _extends2.default)({
    type: "space",
    "data-test-subj": `space-avatar-${space.id}`,
    name: spaceName
  }, !announceSpaceName && {
    // provide empty aria-label so EUI doesn't try to provide its own
    'aria-label': '',
    'aria-hidden': true
  }, {
    size: size || 'm',
    color: (0, _eui.isValidHex)(spaceColor) ? spaceColor : ''
  }, avatarConfig, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }));
};
exports.SpaceAvatarInternal = SpaceAvatarInternal;
SpaceAvatarInternal.defaultProps = {
  announceSpaceName: true
};