"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "addSpaceIdToPath", {
  enumerable: true,
  get: function () {
    return _common.addSpaceIdToPath;
  }
});
exports.plugin = exports.config = void 0;
var _config = require("./config");
var _common = require("../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ // These exports are part of public Spaces plugin contract, any change in signature of exported
// functions or removal of exports should be considered as a breaking change. Ideally we should
// reduce number of such exports to zero and provide everything we want to expose via Setup/Start
// run-time contracts.
// end public contract exports

const config = exports.config = {
  schema: _config.ConfigSchema,
  exposeToBrowser: {
    maxSpaces: true,
    allowFeatureVisibility: true,
    allowSolutionVisibility: true
  }
};
const plugin = async initializerContext => {
  const {
    SpacesPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new SpacesPlugin(initializerContext);
};
exports.plugin = plugin;