"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TheHiveTLP = exports.TheHiveSeverity = exports.THEHIVE_TITLE = exports.THEHIVE_CONNECTOR_ID = exports.SUB_ACTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THEHIVE_TITLE = exports.THEHIVE_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.thehive.connectorTypeTitle', {
  defaultMessage: 'TheHive'
});
const THEHIVE_CONNECTOR_ID = exports.THEHIVE_CONNECTOR_ID = '.thehive';
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["PUSH_TO_SERVICE"] = "pushToService";
  SUB_ACTION["CREATE_ALERT"] = "createAlert";
  return SUB_ACTION;
}({});
let TheHiveSeverity = exports.TheHiveSeverity = /*#__PURE__*/function (TheHiveSeverity) {
  TheHiveSeverity[TheHiveSeverity["LOW"] = 1] = "LOW";
  TheHiveSeverity[TheHiveSeverity["MEDIUM"] = 2] = "MEDIUM";
  TheHiveSeverity[TheHiveSeverity["HIGH"] = 3] = "HIGH";
  TheHiveSeverity[TheHiveSeverity["CRITICAL"] = 4] = "CRITICAL";
  return TheHiveSeverity;
}({});
let TheHiveTLP = exports.TheHiveTLP = /*#__PURE__*/function (TheHiveTLP) {
  TheHiveTLP[TheHiveTLP["CLEAR"] = 0] = "CLEAR";
  TheHiveTLP[TheHiveTLP["GREEN"] = 1] = "GREEN";
  TheHiveTLP[TheHiveTLP["AMBER"] = 2] = "AMBER";
  TheHiveTLP[TheHiveTLP["AMBER_STRICT"] = 3] = "AMBER_STRICT";
  TheHiveTLP[TheHiveTLP["RED"] = 4] = "RED";
  return TheHiveTLP;
}({});