"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = void 0;
var _react = require("react");
var _translations = require("./translations");
var _constants = require("../../../common/slack_api/constants");
var _constants2 = require("../../../common/slack/constants");
var _slack = require("../slack/slack");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const isChannelValid = (channels, channelIds) => {
  if (channels === undefined && !(channelIds !== null && channelIds !== void 0 && channelIds.length) || channelIds === undefined && !(channels !== null && channels !== void 0 && channels.length) || !(channelIds !== null && channelIds !== void 0 && channelIds.length) && !(channels !== null && channels !== void 0 && channels.length)) {
    return false;
  }
  return true;
};
const getConnectorType = () => ({
  id: _constants.SLACK_API_CONNECTOR_ID,
  subtype: _slack.subtype,
  // Hide slack api connector in UI when when slack connector is enabled in config
  getHideInUi: actionTypes => {
    var _actionTypes$find;
    return ((_actionTypes$find = actionTypes.find(actionType => actionType.id === _constants2.SLACK_CONNECTOR_ID)) === null || _actionTypes$find === void 0 ? void 0 : _actionTypes$find.enabledInConfig) === true;
  },
  modalWidth: 675,
  iconClass: 'logoSlack',
  selectMessage: _translations.SELECT_MESSAGE,
  actionTypeTitle: _translations.ACTION_TYPE_TITLE,
  validateParams: async actionParams => {
    const errors = {
      text: new Array(),
      channels: new Array()
    };
    const validationResult = {
      errors
    };
    if (actionParams.subAction === 'postMessage' || actionParams.subAction === 'postBlockkit') {
      if (!actionParams.subActionParams.text) {
        errors.text.push(_translations.MESSAGE_REQUIRED);
      }
      if (!isChannelValid(actionParams.subActionParams.channels, actionParams.subActionParams.channelIds)) {
        errors.channels.push(_translations.CHANNEL_REQUIRED);
      }
      if (actionParams.subAction === 'postBlockkit' && actionParams.subActionParams.text) {
        try {
          const blockkitJson = JSON.parse(actionParams.subActionParams.text);
          if (!Object.hasOwn(blockkitJson, 'blocks')) {
            errors.text.push(_translations.BLOCKS_REQUIRED);
          }
        } catch {
          errors.text.push(_translations.JSON_REQUIRED);
        }
      }
    }
    return validationResult;
  },
  actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./slack_connectors')))),
  actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./slack_params')))),
  convertParamsBetweenGroups: params => {
    if ('message' in params) {
      return {
        subAction: 'postMessage',
        subActionParams: {
          channels: [],
          text: params.message
        }
      };
    } else if ('subAction' in params) {
      return params;
    }
    return {};
  }
});
exports.getConnectorType = getConnectorType;