"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_LABEL = exports.URL_INVALID = exports.METHOD_REQUIRED = exports.METHOD_LABEL = exports.BODY_REQUIRED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METHOD_LABEL = exports.METHOD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.webhook.methodTextFieldLabel', {
  defaultMessage: 'Method'
});
const URL_LABEL = exports.URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.webhook.urlTextFieldLabel', {
  defaultMessage: 'URL'
});
const URL_INVALID = exports.URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.webhook.error.invalidUrlTextField', {
  defaultMessage: 'URL is invalid.'
});
const METHOD_REQUIRED = exports.METHOD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.webhook.error.requiredMethodText', {
  defaultMessage: 'Method is required.'
});
const BODY_REQUIRED = exports.BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.webhook.error.requiredWebhookBodyText', {
  defaultMessage: 'Body is required.'
});