"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfiguration = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/auth/constants");
var _schema = require("../../../common/auth/schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeadersSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string());
const ExternalIncidentServiceConfiguration = exports.ExternalIncidentServiceConfiguration = {
  createIncidentUrl: _configSchema.schema.string(),
  createIncidentMethod: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.WebhookMethods.POST), _configSchema.schema.literal(_constants.WebhookMethods.PUT)], {
    defaultValue: _constants.WebhookMethods.POST
  }),
  createIncidentJson: _configSchema.schema.string(),
  // stringified object
  createIncidentResponseKey: _configSchema.schema.string(),
  getIncidentMethod: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.WebhookMethods.GET), _configSchema.schema.literal(_constants.WebhookMethods.POST)], {
    defaultValue: _constants.WebhookMethods.GET
  }),
  getIncidentUrl: _configSchema.schema.string(),
  getIncidentJson: _configSchema.schema.nullable(_configSchema.schema.string()),
  getIncidentResponseExternalTitleKey: _configSchema.schema.string(),
  viewIncidentUrl: _configSchema.schema.string(),
  updateIncidentUrl: _configSchema.schema.string(),
  updateIncidentMethod: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.WebhookMethods.POST), _configSchema.schema.literal(_constants.WebhookMethods.PATCH), _configSchema.schema.literal(_constants.WebhookMethods.PUT)], {
    defaultValue: _constants.WebhookMethods.PUT
  }),
  updateIncidentJson: _configSchema.schema.string(),
  createCommentUrl: _configSchema.schema.nullable(_configSchema.schema.string()),
  createCommentMethod: _configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.WebhookMethods.POST), _configSchema.schema.literal(_constants.WebhookMethods.PUT), _configSchema.schema.literal(_constants.WebhookMethods.PATCH)], {
    defaultValue: _constants.WebhookMethods.PUT
  })),
  createCommentJson: _configSchema.schema.nullable(_configSchema.schema.string()),
  headers: _configSchema.schema.nullable(HeadersSchema),
  hasAuth: _schema.AuthConfiguration.hasAuth,
  authType: _schema.AuthConfiguration.authType,
  certType: _schema.AuthConfiguration.certType,
  ca: _schema.AuthConfiguration.ca,
  verificationMode: _schema.AuthConfiguration.verificationMode,
  accessTokenUrl: _schema.AuthConfiguration.accessTokenUrl,
  clientId: _schema.AuthConfiguration.clientId,
  scope: _schema.AuthConfiguration.scope,
  additionalFields: _schema.AuthConfiguration.additionalFields
};
const ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = _configSchema.schema.object(ExternalIncidentServiceConfiguration);
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _configSchema.schema.object({
  incident: _configSchema.schema.object({
    title: _configSchema.schema.string(),
    description: _configSchema.schema.nullable(_configSchema.schema.string()),
    id: _configSchema.schema.nullable(_configSchema.schema.string()),
    severity: _configSchema.schema.nullable(_configSchema.schema.string()),
    status: _configSchema.schema.nullable(_configSchema.schema.string()),
    externalId: _configSchema.schema.nullable(_configSchema.schema.string()),
    tags: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }),
  comments: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
    comment: _configSchema.schema.string(),
    commentId: _configSchema.schema.string()
  })))
});
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  subAction: _configSchema.schema.literal('pushToService'),
  subActionParams: ExecutorSubActionPushParamsSchema
})]);
const ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = _schema.SecretConfigurationSchema;