"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSetProcessorToESQL = convertSetProcessorToESQL;
var _esqlAst = require("@kbn/esql-ast");
var _processors = require("../../../../types/processors");
var _condition_to_esql = require("../condition_to_esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertSetProcessorToESQL(processor) {
  const setProcessor = processor;

  // Param validation
  // Throw error if neither `value` nor `copy_from` is specified
  if (setProcessor.value === undefined && setProcessor.copy_from === undefined) {
    throw new Error(`Set processor requires either 'value' or 'copy_from' parameter.`);
  }

  // Throw error if both `value` and `copy_from` are specified
  if (setProcessor.value !== undefined && setProcessor.copy_from !== undefined) {
    throw new Error(`Set processor cannot have both 'value' and 'copy_from' parameters.`);
  }

  // Param handling
  // Handle `copy_from` if specified, otherwise use literal fron `value`
  let valueExpression = (0, _condition_to_esql.esqlLiteralFromAny)(setProcessor.value);
  if (setProcessor.copy_from) {
    valueExpression = _esqlAst.Builder.expression.column(setProcessor.copy_from);
  }
  const whereExpression = processor.where ? (0, _condition_to_esql.conditionToESQLAst)(processor.where) : null;
  const overrideExpression = (0, _processors.isProcessWithOverrideOption)(processor) && processor.override === false ? (0, _condition_to_esql.conditionToESQLAst)({
    field: processor.to,
    exists: false
  }) : null;
  const mergedWhereExpression = whereExpression && overrideExpression ? _esqlAst.Builder.expression.func.binary('and', [whereExpression, overrideExpression]) : whereExpression || overrideExpression;

  // If there's a where condition or override is false, we need to use a CASE statement
  const assignment = mergedWhereExpression ? _esqlAst.Builder.expression.func.call('CASE', [mergedWhereExpression, valueExpression, _esqlAst.Builder.expression.column(setProcessor.to) // ELSE keep existing value
  ]) : valueExpression;
  return [_esqlAst.Builder.command({
    name: 'eval',
    args: [_esqlAst.Builder.expression.func.binary('=', [_esqlAst.Builder.expression.column(setProcessor.to), assignment])]
  })];
}