"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processorFieldRenames = exports.applyPreProcessing = void 0;
exports.renameFields = renameFields;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Mapping of Streamlng processor fields to Ingest processor fields.
 */
const processorFieldRenames = exports.processorFieldRenames = {
  grok: {
    from: 'field',
    where: 'if'
  },
  dissect: {
    from: 'field',
    where: 'if'
  },
  date: {
    from: 'field',
    to: 'target_field',
    where: 'if'
  },
  rename: {
    from: 'field',
    to: 'target_field',
    where: 'if'
  },
  set: {
    to: 'field',
    where: 'if'
  },
  append: {
    to: 'field',
    where: 'if'
  },
  manual_ingest_pipeline: {
    where: 'if'
  }
};
function renameFields(obj, renames) {
  const result = {};
  for (const key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      const newKey = renames[key] || key;
      result[newKey] = obj[key];
    }
  }
  return result;
}
const applyPreProcessing = (action, processorWithRenames) => {
  // Placeholder for future pre-processing logic
  // Currently returns processor as-is without any template escaping
  return [{
    [action]: {
      ...processorWithRenames
    }
  }];
};
exports.applyPreProcessing = applyPreProcessing;