"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  zodRenameFields: true,
  zodRenameFieldsAndRemoveAction: true
};
exports.zodRenameFields = zodRenameFields;
exports.zodRenameFieldsAndRemoveAction = zodRenameFieldsAndRemoveAction;
var _dissect_patterns = require("./dissect_patterns");
Object.keys(_dissect_patterns).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _dissect_patterns[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _dissect_patterns[key];
    }
  });
});
var _grok_patterns = require("./grok_patterns");
Object.keys(_grok_patterns).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _grok_patterns[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _grok_patterns[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Utility type to rename multiple fields in a type

/**
 * Zod helper to rename multiple fields in a Zod object schema.
 */
function zodRenameFields(schema, renames) {
  // Remove old fields
  const newSchema = schema.omit(Object.keys(renames).reduce((acc, key) => ({
    ...acc,
    [key]: true
  }), {}));
  // Add new fields with the same type as the old ones
  const extensions = {};
  for (const oldKey in renames) {
    if (Object.prototype.hasOwnProperty.call(renames, oldKey)) {
      const newKey = renames[oldKey];
      extensions[newKey] = schema.shape[oldKey];
    }
  }
  return newSchema.extend(extensions);
}

/**
 * Zod helper to rename fields and remove the 'action' property.
 */
function zodRenameFieldsAndRemoveAction(schema, renames) {
  return zodRenameFields(schema, renames).omit({
    action: true
  });
}