module.exports = "Write a description of a system. Start out with describing the system briefly. Then identify properties of a system that are useful in understanding what kinds of log messages or events it may produce. Focus on system identity and context such as runtime, environment, operating system, cloud platform, frameworks, and similar factors. Provide examples for each category. Write this description in a way that it can be displayed as-is in the UI. Avoid \"I\", or statements around how you want to approach this task or follow-up suggestions.\n\nConsider the following categories:\n\n1. **System Runtime and Execution Context**\n\n   * Programming language and runtime versions (example: Java 11, Java 17)\n   * Frameworks and libraries in use with their versions (example: Spring Boot 2.x, Spring Boot 3.x, Elasticsearch 7.x, Elasticsearch 8.x)\n   * Application server or container (example: Tomcat, Jetty, Netty)\n   * Interpreter or runtime flags (example: JVM `-XX:+PrintGCDetails`, Node.js with experimental features enabled)\n\n2. **Operating System and Host Environment**\n\n   * OS family and version (example: Linux systemd logs, Windows Event Viewer logs)\n   * Distribution-specific details (example: Ubuntu logs, RHEL logs)\n   * Kernel version or patches (example: network stack errors, memory exhaustion messages)\n   * Filesystem and storage type (example: ext4, XFS, AWS EBS)\n\n3. **Cloud Platform and Infrastructure Layer**\n\n   * Cloud provider (example: AWS, GCP, Azure)\n   * Platform services (example: EKS, GKE, AKS)\n   * Resource identifiers (example: instance types, storage classes, networking modes)\n   * Service mesh or orchestration (example: Istio proxy logs, Linkerd logs, Kubernetes events)\n\n4. **Deployment and Build Context**\n\n   * Application build version or commit hash\n   * Deployment strategy (example: canary deployments, rolling updates)\n   * Configuration and environment variables (example: feature flags enabled or disabled)\n\n5. **Observability Stack Context**\n\n   * Log format and logging library (example: Log4j, SLF4J, Winston, Bunyan)\n   * Structured versus unstructured logs (example: JSON logs with fields like `level`, `service`, `component`)\n   * Instrumentation libraries (example: OpenTelemetry logs with error codes and attributes)\n\n6. **Domain- or Application-Specific Context**\n\n   * Application type (example: web application, database, distributed job scheduler, stream processor)\n   * Critical subsystems (example: authentication, payment processing, message queues)\n   * Regulatory or industry constraints (example: PCI-compliant logs with masked fields)\n\n";
